/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class ForwardMessage
extends BotApiMethod<Message> {
    public static final String PATH = "forwardmessage";
    private static final String CHATID_FIELD = "chat_id";
    private static final String FROMCHATID_FIELD = "from_chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="from_chat_id")
    private String fromChatId;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;

    public ForwardMessage() {
    }

    public ForwardMessage(String chatId, String fromChatId, Integer messageId) {
        this();
        Objects.requireNonNull(chatId);
        Objects.requireNonNull(fromChatId);
        this.chatId = chatId;
        this.fromChatId = fromChatId;
        this.messageId = messageId;
    }

    public ForwardMessage(String chatId, Long fromChatId, Integer messageId) {
        this();
        Objects.requireNonNull(chatId);
        Objects.requireNonNull(fromChatId);
        this.chatId = chatId;
        this.fromChatId = fromChatId.toString();
        this.messageId = messageId;
    }

    public ForwardMessage(Long chatId, String fromChatId, Integer messageId) {
        this();
        Objects.requireNonNull(chatId);
        Objects.requireNonNull(fromChatId);
        this.chatId = chatId.toString();
        this.fromChatId = fromChatId;
        this.messageId = messageId;
    }

    public ForwardMessage(Long chatId, Long fromChatId, Integer messageId) {
        this();
        Objects.requireNonNull(chatId);
        Objects.requireNonNull(fromChatId);
        this.chatId = chatId.toString();
        this.fromChatId = fromChatId.toString();
        this.messageId = messageId;
    }

    public String getChatId() {
        return this.chatId;
    }

    public ForwardMessage setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public ForwardMessage setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public String getFromChatId() {
        return this.fromChatId;
    }

    public ForwardMessage setFromChatId(String fromChatId) {
        this.fromChatId = fromChatId;
        return this;
    }

    public ForwardMessage setFromChatId(Long fromChatId) {
        Objects.requireNonNull(fromChatId);
        this.fromChatId = fromChatId.toString();
        return this;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public ForwardMessage setMessageId(Integer messageId) {
        this.messageId = messageId;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public ForwardMessage enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public ForwardMessage disableNotification() {
        this.disableNotification = true;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.fromChatId == null || this.fromChatId.isEmpty()) {
            throw new TelegramApiValidationException("FromChatId can't be empty", this);
        }
        if (this.messageId == null) {
            throw new TelegramApiValidationException("MessageId can't be empty", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return (Message)result.getResult();
            }
            throw new TelegramApiRequestException("Error forwarding message", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    public String toString() {
        return "ForwardMessage{chatId='" + this.chatId + '\'' + ", fromChatId='" + this.fromChatId + '\'' + ", messageId=" + this.messageId + ", disableNotification=" + this.disableNotification + '}';
    }
}

