/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class SendPhoto
extends PartialBotApiMethod<Message> {
    public static final String PATH = "sendphoto";
    public static final String CHATID_FIELD = "chat_id";
    public static final String PHOTO_FIELD = "photo";
    public static final String CAPTION_FIELD = "caption";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    public static final String PARSEMODE_FIELD = "parse_mode";
    private String chatId;
    private String photo;
    private String caption;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private String parseMode;
    private boolean isNewPhoto;
    private String photoName;
    private File newPhotoFile;
    private InputStream newPhotoStream;

    public String getChatId() {
        return this.chatId;
    }

    public SendPhoto setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SendPhoto setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public String getPhoto() {
        return this.photo;
    }

    public SendPhoto setPhoto(String photo) {
        this.photo = photo;
        this.isNewPhoto = false;
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public SendPhoto setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendPhoto setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendPhoto setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public boolean isNewPhoto() {
        return this.isNewPhoto;
    }

    public String getPhotoName() {
        return this.photoName;
    }

    public File getNewPhotoFile() {
        return this.newPhotoFile;
    }

    public InputStream getNewPhotoStream() {
        return this.newPhotoStream;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendPhoto enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendPhoto disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public SendPhoto setNewPhoto(File file) {
        this.newPhotoFile = file;
        this.isNewPhoto = true;
        return this;
    }

    public SendPhoto setNewPhoto(String photoName, InputStream inputStream) {
        Objects.requireNonNull(photoName, "photoName cannot be null!");
        Objects.requireNonNull(inputStream, "inputStream cannot be null!");
        this.photoName = photoName;
        this.newPhotoStream = inputStream;
        this.isNewPhoto = true;
        return this;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public SendPhoto setParseMode(String parseMode) {
        this.parseMode = parseMode;
        return this;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return (Message)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending photo", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.isNewPhoto) {
            if (this.newPhotoFile == null && this.newPhotoStream == null) {
                throw new TelegramApiValidationException("Photo can't be empty", this);
            }
            if (this.newPhotoStream != null && (this.photoName == null || this.photoName.isEmpty())) {
                throw new TelegramApiValidationException("Photo name can't be empty", this);
            }
        } else if (this.photo == null) {
            throw new TelegramApiValidationException("Photo can't be empty", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public String toString() {
        return "SendPhoto{chatId='" + this.chatId + '\'' + ", photo='" + this.photo + '\'' + ", caption='" + this.caption + '\'' + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", parseMode='" + this.parseMode + '\'' + ", isNewPhoto=" + this.isNewPhoto + ", photoName='" + this.photoName + '\'' + ", newPhotoFile=" + this.newPhotoFile + ", newPhotoStream=" + this.newPhotoStream + '}';
    }
}

