/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class SetChatDescription
extends BotApiMethod<Boolean> {
    public static final String PATH = "setChatDescription";
    private static final String CHATID_FIELD = "chat_id";
    private static final String DESCRIPTION_FIELD = "description";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="description")
    private String description;

    public SetChatDescription() {
    }

    public SetChatDescription(String chatId, String description) {
        this.chatId = (String)Preconditions.checkNotNull((Object)chatId);
        this.description = (String)Preconditions.checkNotNull((Object)description);
    }

    public SetChatDescription(Long chatId, String description) {
        this.chatId = ((Long)Preconditions.checkNotNull((Object)chatId)).toString();
        this.description = (String)Preconditions.checkNotNull((Object)description);
    }

    public String getChatId() {
        return this.chatId;
    }

    public SetChatDescription setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SetChatDescription setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SetChatDescription setDescription(String description) {
        Objects.requireNonNull(description);
        this.description = description;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error setting chat description", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.description == null) {
            throw new TelegramApiValidationException("Description can't be null", this);
        }
    }

    public String toString() {
        return "SetChatDescription{chatId='" + this.chatId + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

