/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.xquery.saxon;

import java.io.IOException;
import javax.xml.transform.Source;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.util.CharsetUtils;
import org.teiid.util.WSUtil;

public class XMLFunctions {
    private static final boolean USE_X_ESCAPE = (Boolean)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.useXMLxEscape", (Object)true, Boolean.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String xpathValue(Object doc, String xpath) throws XPathException, TeiidProcessingException {
        Source s = null;
        try {
            s = XMLSystemFunctions.convertToSource((Object)doc);
            XPathEvaluator eval = new XPathEvaluator();
            XPathExpression expr = eval.createExpression(xpath);
            XPathDynamicContext context = expr.createDynamicContext((Item)eval.getConfiguration().buildDocumentTree(s).getRootNode());
            Item o = expr.evaluateSingle(context);
            if (o == null) {
                String string = null;
                return string;
            }
            if (o instanceof Item) {
                Item i = o;
                if (XMLFunctions.isNull(i)) {
                    String string = null;
                    return string;
                }
                String string = i.getStringValue();
                return string;
            }
            String string = o.toString();
            return string;
        }
        finally {
            WSUtil.closeSource((Source)s);
        }
    }

    public static void validateXpath(String xpath) throws TeiidProcessingException {
        if (xpath == null) {
            return;
        }
        XPathEvaluator eval = new XPathEvaluator();
        try {
            eval.createExpression(xpath);
        }
        catch (XPathException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
    }

    public static String[] validateQName(String name) throws TeiidProcessingException {
        try {
            return NameChecker.getQNameParts((CharSequence)name);
        }
        catch (QNameException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
    }

    public static boolean isValidNCName(String prefix) {
        return NameChecker.isValidNCName((CharSequence)prefix);
    }

    public static boolean isNull(Item i) {
        if (i instanceof NodeInfo) {
            NodeInfo ni = (NodeInfo)i;
            return ni.getNodeKind() == 1 && !ni.hasChildNodes() && Boolean.valueOf(ni.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil")) != false;
        }
        return false;
    }

    public static String escapeName(String name, boolean fully) {
        StringBuilder sb = new StringBuilder();
        char[] chars = name.toCharArray();
        int i = 0;
        boolean surrogatePair = false;
        if (fully && name.regionMatches(true, 0, "xml", 0, 3)) {
            XMLFunctions.escapeChar(sb, name.charAt(0));
            sb.append(chars, 1, 2);
            i = 3;
        }
        while (i < chars.length) {
            block10: {
                int chr = chars[i];
                switch (chr) {
                    case 58: {
                        if (!fully && i != 0) break;
                        XMLFunctions.escapeChar(sb, chr);
                        break block10;
                    }
                    case 95: {
                        if (chars.length <= i + 1 || chars[i + 1] != 'x') break;
                        XMLFunctions.escapeChar(sb, chr);
                        break block10;
                    }
                    default: {
                        int codepoint = chr;
                        if (i + 1 < chars.length && Character.isSurrogatePair((char)chr, chars[i + 1])) {
                            codepoint = Character.toCodePoint((char)chr, chars[++i]);
                            surrogatePair = true;
                        }
                        if (i == (surrogatePair ? 1 : 0)) {
                            if (NameChecker.isNCNameStartChar((int)codepoint)) break;
                            XMLFunctions.escapeChar(sb, codepoint);
                        } else {
                            if (NameChecker.isNCNameChar((int)codepoint)) break;
                            XMLFunctions.escapeChar(sb, codepoint);
                        }
                        break block10;
                    }
                }
                sb.append((char)chr);
                if (surrogatePair) {
                    sb.append(chars[i]);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static void escapeChar(StringBuilder sb, int chr) {
        boolean bmp = Character.isBmpCodePoint(chr);
        if (USE_X_ESCAPE) {
            sb.append("_x");
        } else {
            sb.append("_u");
        }
        try {
            if (!bmp) {
                byte high = (byte)(chr >> 16);
                CharsetUtils.toHex((Appendable)sb, (byte)high);
            }
            CharsetUtils.toHex((Appendable)sb, (byte)((byte)(chr >> 8)));
            CharsetUtils.toHex((Appendable)sb, (byte)((byte)chr));
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        sb.append("_");
    }
}

