/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu.util;

import com.electronwill.nightconfig.core.CommentedConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;

public final class TomlUtils {
    public static final String EQUALS = "=";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String TOOL_POETRY_DEPENDENCIES = "tool.poetry.dependencies";
    public static final String TOOL_POETRY_DEV_DEPENDENCIES = "tool.poetry.group.dev.dependencies";
    public static final String TOOL_POETRY_GROUP_MONOREPO_DEPENDENCIES = "tool.poetry.group.monorepo.dependencies";
    public static final String VERSION = "version";
    public static final String PATH = "path";
    public static final String DEVELOP = "develop";
    public static final String EXTRAS = "extras";
    public static final String BUILD_SYSTEM = "build-system";
    public static final String REQUIRES = "requires";
    public static final String POETRY_CORE = "poetry-core";
    public static final String DOT = ".";

    protected TomlUtils() {
    }

    public static boolean representsLocalDevelopmentVersion(Object rawData) {
        CommentedConfig config;
        boolean localDevelopmentVersion = false;
        if (rawData instanceof CommentedConfig && !(config = (CommentedConfig)rawData).contains(VERSION)) {
            localDevelopmentVersion = true;
        }
        return localDevelopmentVersion;
    }

    public static String escapeTomlRightHandSide(String valueToEscape) {
        return !valueToEscape.contains("{") ? DOUBLE_QUOTE + valueToEscape + DOUBLE_QUOTE : valueToEscape;
    }

    public static void writeTomlFile(File pyProjectTomlFile, String fileContent) throws IOException {
        if (fileContent != null) {
            try (FileWriter writer = new FileWriter(pyProjectTomlFile);){
                writer.write(fileContent);
            }
        }
    }

    public static String convertCommentedConfigToToml(CommentedConfig config) {
        int valuesRemaining = config.size();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (config.get(PATH) != null) {
            sb.append(PATH).append(" = \"").append(config.get(PATH).toString()).append(DOUBLE_QUOTE);
            TomlUtils.addCommaBetweenValues(--valuesRemaining, sb);
        }
        if (config.get(DEVELOP) != null) {
            sb.append(DEVELOP).append(" = ").append(config.get(DEVELOP).toString());
            TomlUtils.addCommaBetweenValues(--valuesRemaining, sb);
        }
        if (config.get(VERSION) != null) {
            sb.append(VERSION).append(" = \"").append(config.get(VERSION).toString()).append(DOUBLE_QUOTE);
            List extras = (List)config.get(EXTRAS);
            if (CollectionUtils.isNotEmpty((Collection)extras)) {
                sb.append(", ").append(EXTRAS).append(" = [");
                for (int i = 0; i < extras.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(DOUBLE_QUOTE).append((String)extras.get(i)).append(DOUBLE_QUOTE);
                }
                sb.append("]");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private static void addCommaBetweenValues(int valuesRemaining, StringBuilder sb) {
        if (valuesRemaining > 0) {
            sb.append(", ");
        }
    }

    public static int getIndexOfFirstDigit(String input) {
        Pattern pattern = Pattern.compile("\\d");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    public static int getIndexOfLastDigit(String input) {
        Pattern pattern = Pattern.compile("\\d");
        Matcher matcher = pattern.matcher(input);
        int lastDigitIndex = -1;
        while (matcher.find()) {
            lastDigitIndex = matcher.end();
        }
        return lastDigitIndex;
    }
}

