/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.PyenvAndPoetrySetup;
import org.technologybrewery.habushu.exec.PoetryCommandHelper;

public final class HabushuUtil {
    private static final Logger logger = LoggerFactory.getLogger(HabushuUtil.class);

    private HabushuUtil() {
    }

    public static void runBashScript(String bashScriptPath) {
        HabushuUtil.runBashScript(bashScriptPath, null, true);
    }

    public static void runBashScript(String bashScriptPath, String[] parameters, boolean debug) {
        logger.debug("Running bash script located at {}.", (Object)bashScriptPath);
        try {
            String line;
            String[] command;
            if (parameters != null && parameters.length > 0) {
                command = new String[parameters.length + 1];
                for (int i = 0; i < parameters.length; ++i) {
                    command[i + 1] = parameters[i];
                }
            } else {
                command = new String[]{bashScriptPath};
            }
            Process process = Runtime.getRuntime().exec(command);
            StringBuilder output = new StringBuilder();
            BufferedReader stdInReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = stdInReader.readLine()) != null) {
                output.append(line + "\n");
            }
            BufferedReader stdErrReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = stdErrReader.readLine()) != null) {
                output.append(line + "\n");
            }
            if (debug) {
                logger.debug(output.toString());
            } else {
                logger.info(output.toString());
            }
            int exitVal = process.waitFor();
            if (exitVal != 0) {
                throw new HabushuException("Error encountered when running bash script located at " + bashScriptPath + "\n    Can run maven build with -X to see the output of the failed script.");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new HabushuException("Could not run bash script.", e);
        }
    }

    public static void writeLinesToFile(String commands, String filePath) {
        logger.debug("Writing lines to file located at {}.", (Object)filePath);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
            writer.write(commands);
        }
        catch (IOException e) {
            throw new HabushuException("Could not write to file.", e);
        }
    }

    public static void createFileAndGivePermissions(File newFile) {
        logger.debug("Creating new file at {}.", (Object)newFile.getAbsolutePath());
        newFile = new File(newFile.getAbsolutePath());
        if (!newFile.exists()) {
            try {
                newFile.createNewFile();
            }
            catch (IOException e) {
                throw new HabushuException("Could not create new file.", e);
            }
        }
        HabushuUtil.giveFullFilePermissions(newFile.getAbsolutePath());
    }

    public static void giveFullFilePermissions(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            file.setExecutable(true, false);
            file.setReadable(true, false);
            file.setWritable(true, false);
        }
    }

    public static void copyFile(String sourceFilePath, String destinationFilePath) {
        try {
            File sourceFile = new File(sourceFilePath);
            File destinationFile = new File(destinationFilePath);
            FileUtils.copyFile((File)sourceFile, (File)destinationFile);
        }
        catch (IOException ioe) {
            throw new HabushuException("Could not copy the file [" + sourceFilePath + "] to [" + destinationFilePath + "]!", ioe);
        }
    }

    public static String getInProjectVirtualEnvironmentPath(File workingDirectory) {
        return workingDirectory.getAbsolutePath() + "/.venv";
    }

    public static String findCurrentVirtualEnvironmentFullPath(String pythonVersion, boolean usePyenv, File patchInstallScript, File workingDirectory, boolean rewriteLocalPathDepsInArchives, Log log) throws MojoExecutionException {
        String virtualEnvFullPath = null;
        PyenvAndPoetrySetup configureTools = new PyenvAndPoetrySetup(pythonVersion, usePyenv, patchInstallScript, workingDirectory, rewriteLocalPathDepsInArchives, log);
        configureTools.execute();
        try {
            PoetryCommandHelper poetryHelper = new PoetryCommandHelper(workingDirectory);
            virtualEnvFullPath = poetryHelper.execute(Arrays.asList("env", "list", "--full-path"));
        }
        catch (RuntimeException e) {
            log.debug((CharSequence)"Could not retrieve Poetry-managed virtual environment path - it likely does not exist", (Throwable)e);
        }
        return virtualEnvFullPath;
    }

    public static String getCleanVirtualEnvironmentPath(String virtualEnvFullPath) {
        return StringUtils.replace((String)virtualEnvFullPath, (String)" (Activated)", (String)"");
    }
}

