/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.habushu.HabushuException;

public class ContainerizeDepsDockerfileHelper {
    public static final String HABUSHU_FINAL_STAGE = "#HABUSHU_FINAL_STAGE";
    public static final String HABUSHU_BUILDER_STAGE = "#HABUSHU_BUILDER_STAGE";
    public static final String HABUSHU_COMMENT_START = " - HABUSHU GENERATED CODE (DO NOT MODIFY)";
    public static final String HABUSHU_COMMENT_END = " - HABUSHU GENERATED CODE (END)";
    public static final String REPLACE_WITH_SINGLE_REPO_PROJECT_DIR = "REPLACE_WITH_SINGLE_REPO_PROJECT_DIR";
    public static final String CHOWN = "CHOWN_PLACEHOLDER";
    public static final String BASE_IMAGE = "BASE_IMAGE";
    public static final String ANCHOR_DIRECTORY = "ANCHOR_DIRECTORY";
    public static final String FINAL_STAGE_TEMPLATE = "dockerfile_final_stage_template";
    public static final String BUILDER_STAGE_TEMPLATE = "dockerfile_builder_stage_template";

    public static String createContainerStageContentFrom(String template, String anchorDirectory, String moduleBaseDir, String owner, String baseImage) {
        StringBuilder content = new StringBuilder();
        InputStream inputStream = ContainerizeDepsDockerfileHelper.class.getClassLoader().getResourceAsStream(template);
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader buffer = new BufferedReader(inputStreamReader);){
            String line = buffer.readLine();
            while (line != null) {
                if ((line = line.stripTrailing()).contains(ANCHOR_DIRECTORY)) {
                    line = line.replaceAll(ANCHOR_DIRECTORY, anchorDirectory);
                }
                if (line.contains(REPLACE_WITH_SINGLE_REPO_PROJECT_DIR)) {
                    line = line.replaceAll(REPLACE_WITH_SINGLE_REPO_PROJECT_DIR, moduleBaseDir);
                }
                if (line.contains(CHOWN)) {
                    line = StringUtils.isNotBlank((CharSequence)owner) ? line.replaceAll(CHOWN, "--chown=" + owner) : line.replaceAll(CHOWN, "");
                }
                if (line.contains(BASE_IMAGE)) {
                    line = line.replaceAll(BASE_IMAGE, baseImage);
                }
                content.append(line).append("\n");
                line = buffer.readLine();
            }
            inputStream.close();
        }
        catch (IOException e) {
            throw new HabushuException("Could not read from file.", e);
        }
        return content.toString();
    }

    public static String updateDockerfileWithContainerStageLogic(File dockerFile, String anchorDirectory, String moduleBaseDir, String owner, String builderBaseImage, String finalBaseImage) {
        String builderStageContent = ContainerizeDepsDockerfileHelper.createContainerStageContentFrom(BUILDER_STAGE_TEMPLATE, anchorDirectory, moduleBaseDir, owner, builderBaseImage);
        String finalStageContent = ContainerizeDepsDockerfileHelper.createContainerStageContentFrom(FINAL_STAGE_TEMPLATE, null, null, owner, finalBaseImage);
        StringBuilder content = new StringBuilder();
        boolean builderStageContentIncluded = false;
        boolean finalStageContentIncluded = false;
        int firstFromLine = -1;
        boolean skipLine = false;
        try (BufferedReader buffer = new BufferedReader(new FileReader(dockerFile));){
            String line = buffer.readLine();
            while (line != null) {
                line = line.stripTrailing();
                if (firstFromLine < 0 && line.strip().startsWith("FROM")) {
                    firstFromLine = content.length();
                }
                if (!skipLine && line.contains(HABUSHU_COMMENT_START)) {
                    skipLine = true;
                }
                if (skipLine && line.contains(HABUSHU_COMMENT_END)) {
                    skipLine = false;
                }
                if (!skipLine) {
                    if (line.contains(HABUSHU_BUILDER_STAGE)) {
                        line = ContainerizeDepsDockerfileHelper.wrapWithHabushuComment(builderStageContent, HABUSHU_BUILDER_STAGE);
                        builderStageContentIncluded = true;
                    }
                    if (line.contains(HABUSHU_FINAL_STAGE)) {
                        line = ContainerizeDepsDockerfileHelper.wrapWithHabushuComment(finalStageContent, HABUSHU_FINAL_STAGE);
                        finalStageContentIncluded = true;
                    }
                    content.append(line).append("\n");
                }
                line = buffer.readLine();
            }
            if (!builderStageContentIncluded) {
                content.insert(Integer.max(firstFromLine, 0), ContainerizeDepsDockerfileHelper.wrapWithHabushuComment(builderStageContent, HABUSHU_BUILDER_STAGE) + "\n\n");
            }
            if (!finalStageContentIncluded) {
                content.append("\n");
                content.append(ContainerizeDepsDockerfileHelper.wrapWithHabushuComment(finalStageContent, HABUSHU_FINAL_STAGE)).append("\n");
            }
        }
        catch (IOException e) {
            throw new HabushuException("Could not update Dockerfile with container stage logic.", e);
        }
        return content.toString();
    }

    private static String wrapWithHabushuComment(String content, String stage) {
        StringBuilder contentBuilder = new StringBuilder();
        contentBuilder.append(stage).append(HABUSHU_COMMENT_START).append("\n");
        contentBuilder.append(content);
        contentBuilder.append(stage).append(HABUSHU_COMMENT_END);
        return contentBuilder.toString();
    }
}

