/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu.migration;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.vdurmont.semver4j.Semver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.AbstractMigration;
import org.technologybrewery.baton.BatonException;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.util.TomlReplacementTuple;
import org.technologybrewery.habushu.util.TomlUtils;

public class CustomPoetrycoreVersionMigration
extends AbstractMigration {
    public static final Logger logger = LoggerFactory.getLogger(CustomPoetrycoreVersionMigration.class);
    protected Map<String, TomlReplacementTuple> replacements = new HashMap<String, TomlReplacementTuple>();
    private boolean isPoetryCoreVersionUpdateRequired;
    private static final String POETRY_CORE_REQUIRED_VERSION = "^1.6.0".substring(1);

    protected boolean shouldExecuteOnFile(File file) {
        block8: {
            try (FileConfig tomlFileConfig = FileConfig.of((File)file);){
                tomlFileConfig.load();
                Optional toolBuildSystem = tomlFileConfig.getOptional("build-system");
                if (!toolBuildSystem.isPresent()) break block8;
                Config buildSystem = (Config)toolBuildSystem.get();
                Map dependencyMap = buildSystem.valueMap();
                for (Map.Entry<String, Object> entry : dependencyMap.entrySet()) {
                    if (!this.isPoetrycoreUpgradeRequired(entry)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    protected boolean performMigration(File pyProjectTomlFile) {
        Object fileContent = "";
        try (BufferedReader reader = new BufferedReader(new FileReader(pyProjectTomlFile));){
            String line = reader.readLine();
            while (line != null) {
                if (line.contains(" ") && line.contains("=")) {
                    String key = line.substring(0, line.indexOf(" "));
                    if (key == null) {
                        key = line.substring(0, line.indexOf("="));
                    } else {
                        TomlReplacementTuple matchedTuple = this.replacements.get(key = key.strip());
                        if (matchedTuple != null && line.contains("poetry-core") && line.contains("=")) {
                            StringBuilder stringBuilder = new StringBuilder(line);
                            if (this.isPoetryCoreVersionUpdateRequired) {
                                int versionIndex = line.lastIndexOf("=") + 1;
                                int endVersionIndex = line.lastIndexOf(".") + 2;
                                if (line.lastIndexOf(".") == -1) {
                                    endVersionIndex = versionIndex + 1;
                                }
                                line = stringBuilder.replace(versionIndex, endVersionIndex, POETRY_CORE_REQUIRED_VERSION).toString();
                                logger.info("Updating poetry-core version to {}.", (Object)POETRY_CORE_REQUIRED_VERSION);
                            }
                        }
                    }
                }
                fileContent = (String)fileContent + line + "\n";
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new HabushuException("Problem reading pyproject.toml while updating the build-sytem's Poetry-core version!", e);
        }
        try {
            TomlUtils.writeTomlFile(pyProjectTomlFile, (String)fileContent);
        }
        catch (IOException e) {
            throw new BatonException("Problem while writing dependencies to TomlFile while updating the build-system's Poetry-core version!", (Throwable)e);
        }
        return true;
    }

    private boolean isPoetrycoreUpgradeRequired(Map.Entry<String, Object> dependency) {
        String dependencyVal;
        String packageName = dependency.getKey();
        if (packageName.equals("requires") && (dependencyVal = dependency.getValue().toString()).contains("poetry-core") && dependencyVal.contains("=")) {
            String poetrycoreVerFromToml = dependencyVal.substring(TomlUtils.getIndexOfFirstDigit(dependencyVal), TomlUtils.getIndexOfLastDigit(dependencyVal));
            String poetrycoreVer = this.formatSemVerString(poetrycoreVerFromToml);
            Semver poetryCoreSemVer = new Semver(poetrycoreVerFromToml, Semver.SemverType.NPM);
            Semver poetryCoreSemVerReqVersion = new Semver(POETRY_CORE_REQUIRED_VERSION, Semver.SemverType.NPM);
            if (poetryCoreSemVer.isLowerThan(poetryCoreSemVerReqVersion)) {
                this.isPoetryCoreVersionUpdateRequired = true;
                TomlReplacementTuple replacementTuple = new TomlReplacementTuple(packageName, poetrycoreVer, this.getUpdatedOperatorAndVersion());
                this.replacements.put(packageName, replacementTuple);
                logger.info("Found build-system's poetry-core version : {} less than the required version for Habushu. It will be updated to the required version of {}.", (Object)poetrycoreVer, (Object)POETRY_CORE_REQUIRED_VERSION);
                return true;
            }
        }
        return false;
    }

    private String formatSemVerString(String poetryCoreVer) {
        Object formattedString = "0.0.0";
        if (Pattern.matches("\\d", poetryCoreVer)) {
            formattedString = poetryCoreVer + ".0.0";
        } else if (Pattern.matches("\\d\\.\\d", poetryCoreVer)) {
            formattedString = poetryCoreVer + ".0";
        } else if (Pattern.matches("\\d\\.\\d\\.\\d", poetryCoreVer)) {
            formattedString = poetryCoreVer;
        }
        return formattedString;
    }

    private String getUpdatedOperatorAndVersion() {
        return "poetry-core>=" + POETRY_CORE_REQUIRED_VERSION;
    }
}

