/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu.migration;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.AbstractMigration;
import org.technologybrewery.baton.BatonException;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.util.TomlReplacementTuple;
import org.technologybrewery.habushu.util.TomlUtils;

public abstract class AbstractTomlGroupMigration
extends AbstractMigration {
    public static final Logger logger = LoggerFactory.getLogger(AbstractTomlGroupMigration.class);
    protected Map<String, TomlReplacementTuple> replacements = new HashMap<String, TomlReplacementTuple>();
    private boolean hasExistingNewGroup = false;

    protected abstract String getLegacyGroupName();

    protected abstract String getNewGroupName();

    protected boolean shouldExecuteOnFile(File file) {
        this.replacements.clear();
        boolean shouldExecute = false;
        try (FileConfig tomlFileConfig = FileConfig.of((File)file);){
            tomlFileConfig.load();
            String legacyGroup = this.getLegacyGroupName();
            Optional legacyGroupEntries = tomlFileConfig.getOptional(legacyGroup);
            if (legacyGroupEntries.isPresent()) {
                Config foundGroupEntries = (Config)legacyGroupEntries.get();
                Map groupEntryMap = foundGroupEntries.valueMap();
                for (Map.Entry groupEntry : groupEntryMap.entrySet()) {
                    String groupEntryName = (String)groupEntry.getKey();
                    Object groupEntryRhs = groupEntry.getValue();
                    String groupEntryRshAsString = null;
                    groupEntryRshAsString = groupEntryRhs instanceof CommentedConfig ? TomlUtils.convertCommentedConfigToToml((CommentedConfig)groupEntryRhs) : (String)groupEntryRhs;
                    logger.info("Found [{}] group entry to migrate! ({} = {})", new Object[]{legacyGroup, groupEntryName, groupEntryRshAsString});
                    TomlReplacementTuple replacementTuple = new TomlReplacementTuple(groupEntryName, groupEntryRshAsString, "");
                    this.replacements.put(groupEntryName, replacementTuple);
                }
                String newGroupName = this.getNewGroupName();
                Optional newGroupEntries = tomlFileConfig.getOptional(newGroupName);
                this.hasExistingNewGroup = newGroupEntries.isPresent();
                shouldExecute = true;
            }
        }
        return shouldExecute;
    }

    protected boolean performMigration(File pyProjectTomlFile) {
        Object fileContent = "";
        String newGroupName = this.getNewGroupName();
        try (BufferedReader reader = new BufferedReader(new FileReader(pyProjectTomlFile));){
            String line = reader.readLine();
            boolean injectAfterNextEmptyLine = false;
            while (line != null) {
                String key;
                boolean addLine = true;
                boolean isEmptyLine = line.isBlank();
                if (line.contains(" ") && line.contains("=")) {
                    TomlReplacementTuple matchedTuple;
                    key = line.substring(0, line.indexOf(" "));
                    if (key == null) {
                        key = line.substring(0, line.indexOf("="));
                    }
                    if (key != null && (matchedTuple = this.replacements.get(key = key.strip())) != null) {
                        addLine = false;
                    }
                } else if (line.contains("[") && line.contains("]")) {
                    key = line.strip();
                    if (this.hasExistingNewGroup && key.equals("[" + newGroupName + "]")) {
                        addLine = false;
                        fileContent = (String)fileContent + line + "\n";
                        fileContent = this.injectDependencies((String)fileContent);
                    } else if (!this.hasExistingNewGroup) {
                        injectAfterNextEmptyLine = true;
                    }
                    String legacyGroupName = this.getLegacyGroupName();
                    if (key.equals("[" + legacyGroupName + "]")) {
                        addLine = false;
                    }
                }
                if (isEmptyLine && injectAfterNextEmptyLine) {
                    fileContent = (String)fileContent + "\n[" + newGroupName + "]\n";
                    fileContent = this.injectDependencies((String)fileContent);
                    injectAfterNextEmptyLine = false;
                }
                if (addLine) {
                    fileContent = (String)fileContent + line + "\n";
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new HabushuException("Problem reading pyproject.toml to migrate groups!", e);
        }
        try {
            TomlUtils.writeTomlFile(pyProjectTomlFile, (String)fileContent);
        }
        catch (IOException e) {
            throw new BatonException("Problem moving monorepo dependencies to [" + newGroupName + "]!", (Throwable)e);
        }
        return true;
    }

    private String injectDependencies(String fileContent) {
        for (Map.Entry<String, TomlReplacementTuple> entry : this.replacements.entrySet()) {
            fileContent = (String)fileContent + entry.getKey() + " = " + TomlUtils.escapeTomlRightHandSide(entry.getValue().getOriginalOperatorAndVersion()) + "\n";
        }
        return fileContent;
    }
}

