/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.technologybrewery.habushu.exec.Platform;
import org.technologybrewery.habushu.exec.ProcessExecutor;

public class PythonVersionHelper {
    private static final Logger logger = LoggerFactory.getLogger(PythonVersionHelper.class);
    private static final String PYTHON_COMMAND = "python";
    private static final String PYTHON_3_COMMAND = "python3";
    private static final String PYTHON_VERSION_3_REGEX = "^3.*";
    private static final String EXTRACT_VERSION_REGEX = "^.*?(?=(\\d))";
    private final String desiredPythonVersion;
    private final File workingDirectory;

    public PythonVersionHelper(File workingDirectory, String desiredPythonVersion) {
        Validate.notNull((Object)desiredPythonVersion);
        this.workingDirectory = workingDirectory;
        this.desiredPythonVersion = desiredPythonVersion;
    }

    public String getCurrentPythonVersion() throws MojoExecutionException {
        String version = this.quietlyExecute(Collections.singletonList("--version"));
        return version.replaceAll(EXTRACT_VERSION_REGEX, "");
    }

    protected String quietlyExecute(List<String> arguments) throws MojoExecutionException {
        return this.execute(arguments, Level.DEBUG);
    }

    protected String execute(List<String> arguments) throws MojoExecutionException {
        return this.execute(arguments, Level.INFO);
    }

    private String execute(List<String> arguments, Level logLevel) throws MojoExecutionException {
        String pythonCommand;
        ProcessExecutor executor;
        if (this.desiredPythonVersion.matches(PYTHON_VERSION_3_REGEX) && this.isPython3Installed()) {
            executor = this.createPythonExecutor(PYTHON_3_COMMAND, arguments);
            pythonCommand = PYTHON_3_COMMAND;
        } else {
            executor = this.createPythonExecutor(PYTHON_COMMAND, arguments);
            pythonCommand = PYTHON_COMMAND;
        }
        if (logger.isInfoEnabled() || logger.isDebugEnabled()) {
            String logStatement = String.format("Executing command: %s %s", pythonCommand, StringUtils.join(arguments, (String)" "));
            if (Level.INFO.equals((Object)logLevel)) {
                logger.info(logStatement);
            } else if (Level.DEBUG.equals((Object)logLevel)) {
                logger.debug(logStatement);
            }
        }
        return executor.executeAndGetResult(logger);
    }

    private ProcessExecutor createPythonExecutor(String pythonCommand, List<String> arguments) {
        ArrayList<String> fullCommandArgs = new ArrayList<String>();
        fullCommandArgs.add(pythonCommand);
        fullCommandArgs.addAll(arguments);
        return new ProcessExecutor(this.workingDirectory, fullCommandArgs, Platform.guess(), null);
    }

    private boolean isPython3Installed() {
        try {
            ProcessExecutor executor = this.createPythonExecutor(PYTHON_3_COMMAND, Collections.singletonList("--version"));
            executor.executeAndGetResult(logger);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }
}

