/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.exec.Platform;
import org.technologybrewery.habushu.exec.ProcessExecutor;
import org.technologybrewery.habushu.util.HabushuUtil;

public class PyenvCommandHelper {
    private static final String PYENV_COMMAND = "pyenv";
    private static final Logger logger = LoggerFactory.getLogger(PyenvCommandHelper.class);
    private File workingDirectory;

    public PyenvCommandHelper(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public boolean isPyenvInstalled() {
        try {
            String foundVersion = this.executeWithDebugLogging(Arrays.asList("--version"));
            logger.debug("Found {}", (Object)foundVersion);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public String getCurrentPythonVersion() throws MojoExecutionException {
        return this.executeWithDebugLogging(Arrays.asList("version-name"));
    }

    public void updatePythonVersion(String targetVersion, File patchInstallScript) throws MojoExecutionException {
        List<String> installedPythonVersions = this.getInstalledPythonVersions();
        if (!installedPythonVersions.contains(targetVersion)) {
            logger.info("Could not find Python version {} in following versions [{}] that are installed via pyenv. Installing version {} now...", new Object[]{targetVersion, StringUtils.join(installedPythonVersions, (String)", "), targetVersion});
            this.installPythonVersion(targetVersion, patchInstallScript);
        }
        this.execute(Arrays.asList("local", targetVersion));
    }

    private List<String> getInstalledPythonVersions() throws MojoExecutionException {
        String versionsResult = this.execute(Arrays.asList("versions", "--bare"));
        if (StringUtils.isNotEmpty((CharSequence)versionsResult)) {
            return Arrays.asList(StringUtils.split((String)versionsResult));
        }
        return Collections.emptyList();
    }

    private void installPythonVersion(String targetVersion, File patchInstallScript) {
        try {
            this.execute(Arrays.asList("install", targetVersion));
        }
        catch (Throwable t) {
            logger.warn("Could not install Python {} via normal install, attempting install with patch...", (Object)targetVersion);
            this.installPythonVersionViaPatch(targetVersion, patchInstallScript);
        }
    }

    private void installPythonVersionViaPatch(String pythonVersion, File patchInstallScript) {
        HabushuUtil.createFileAndGivePermissions(patchInstallScript);
        StringBuilder commandList = new StringBuilder();
        commandList.append("#!/bin/bash\n");
        commandList.append("pyenv install --patch ");
        commandList.append(pythonVersion);
        commandList.append(" < <(curl -sSL https://github.com/python/cpython/commit/8ea6353.patch\\?full_index\\=1) \n");
        HabushuUtil.writeLinesToFile(commandList.toString(), patchInstallScript.getAbsolutePath());
        try {
            HabushuUtil.runBashScript(patchInstallScript.getAbsolutePath());
        }
        catch (Throwable t) {
            throw new HabushuException(String.format("Failed to install Python version %s with patch", pythonVersion), t);
        }
    }

    protected String execute(List<String> arguments) throws MojoExecutionException {
        return this.execute(arguments, Level.INFO);
    }

    protected String executeWithDebugLogging(List<String> arguments) throws MojoExecutionException {
        return this.execute(arguments, Level.DEBUG);
    }

    private String execute(List<String> arguments, Level logLevel) {
        ProcessExecutor executor = this.createPyenvExecutor(arguments);
        if (Level.DEBUG.equals((Object)logLevel) && logger.isDebugEnabled()) {
            logger.debug("Executing pyenv command: {} {}", (Object)PYENV_COMMAND, (Object)StringUtils.join(arguments, (String)" "));
        } else if (Level.INFO.equals((Object)logLevel) && logger.isInfoEnabled()) {
            logger.info("Executing pyenv command: {} {}", (Object)PYENV_COMMAND, (Object)StringUtils.join(arguments, (String)" "));
        }
        return executor.executeAndGetResult(logger);
    }

    protected ProcessExecutor createPyenvExecutor(List<String> arguments) {
        ArrayList<String> fullCommandArgs = new ArrayList<String>();
        fullCommandArgs.add(PYENV_COMMAND);
        fullCommandArgs.addAll(arguments);
        return new ProcessExecutor(this.workingDirectory, fullCommandArgs, Platform.guess(), null);
    }
}

