/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu.exec;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.exec.Platform;

public class ProcessExecutor {
    private static final String PATH_ENV_VAR = "PATH";
    private Map<String, String> environment;
    private CommandLine commandLine;
    private Executor executor;

    public ProcessExecutor(File workingDirectory, List<String> command, Platform platform, Map<String, String> additionalEnvironment) {
        this(workingDirectory, new ArrayList<String>(), command, platform, additionalEnvironment, 0L);
    }

    public ProcessExecutor(File workingDirectory, List<String> paths, List<String> command, Platform platform, Map<String, String> additionalEnvironment) {
        this(workingDirectory, paths, command, platform, additionalEnvironment, 0L);
    }

    public ProcessExecutor(File workingDirectory, List<String> paths, List<String> command, Platform platform, Map<String, String> additionalEnvironment, long timeoutInSeconds) {
        this.environment = this.createEnvironment(paths, platform, additionalEnvironment);
        this.commandLine = this.createCommandLine(command);
        this.executor = this.createExecutor(workingDirectory, timeoutInSeconds);
    }

    public String executeAndGetResult(Logger logger) {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        int exitValue = -1;
        try {
            exitValue = this.execute(logger, stdout, stderr);
        }
        catch (Throwable e) {
            this.displayProcessOutputForException(stdout, logger);
            this.displayProcessOutputForException(stderr, logger);
            throw new HabushuException("Could not invoke command! See output above.", e);
        }
        if (exitValue == 0) {
            String result = stdout.toString().trim();
            if (StringUtils.isBlank((CharSequence)result)) {
                result = stderr.toString().trim();
            }
            return result;
        }
        throw new HabushuException(stdout + " " + stderr);
    }

    public int executeAndRedirectOutput(Logger logger) {
        LoggerOutputStream stdout = new LoggerOutputStream(logger, 0);
        LoggerOutputStream stderr = new LoggerOutputStream(logger, 0);
        try {
            int n = this.execute(logger, (OutputStream)((Object)stdout), (OutputStream)((Object)stderr));
            return n;
        }
        catch (Throwable e) {
            throw new HabushuException("Could not invoke command! See output above.", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)((Object)stdout));
            IOUtils.closeQuietly((OutputStream)((Object)stderr));
        }
    }

    private int execute(Logger logger, OutputStream stdout, OutputStream stderr) {
        logger.debug("Executing command line {}", (Object)this.commandLine);
        logger.debug("Active PATH: {}", (Object)this.environment.get(PATH_ENV_VAR));
        try {
            PumpStreamHandler streamHandler = new PumpStreamHandler(stdout, stderr);
            this.executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
            int exitValue = this.executor.execute(this.commandLine, this.environment);
            logger.debug("Exit value {}", (Object)exitValue);
            return exitValue;
        }
        catch (ExecuteException e) {
            if (this.executor.getWatchdog() != null && this.executor.getWatchdog().killedProcess()) {
                throw new HabushuException("Process killed after timeout");
            }
            throw new HabushuException(e);
        }
        catch (IOException e) {
            throw new HabushuException(e);
        }
    }

    private CommandLine createCommandLine(List<String> command) {
        CommandLine commmandLine = new CommandLine(command.get(0));
        for (int i = 1; i < command.size(); ++i) {
            String argument = command.get(i);
            commmandLine.addArgument(argument, false);
        }
        return commmandLine;
    }

    private Map<String, String> createEnvironment(List<String> paths, Platform platform, Map<String, String> additionalEnvironment) {
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        if (additionalEnvironment != null) {
            environment.putAll(additionalEnvironment);
        }
        if (platform.isWindows()) {
            for (Map.Entry entry : environment.entrySet()) {
                String pathName = (String)entry.getKey();
                if (!PATH_ENV_VAR.equalsIgnoreCase(pathName)) continue;
                String pathValue = (String)entry.getValue();
                environment.put(pathName, this.extendPathVariable(pathValue, paths));
            }
        } else {
            String pathValue = (String)environment.get(PATH_ENV_VAR);
            environment.put(PATH_ENV_VAR, this.extendPathVariable(pathValue, paths));
        }
        return environment;
    }

    private String extendPathVariable(String existingValue, List<String> paths) {
        StringBuilder pathBuilder = new StringBuilder();
        for (String path : paths) {
            pathBuilder.append(path).append(File.pathSeparator);
        }
        if (existingValue != null) {
            pathBuilder.append(existingValue).append(File.pathSeparator);
        }
        return pathBuilder.toString();
    }

    private Executor createExecutor(File workingDirectory, long timeoutInSeconds) {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(workingDirectory);
        executor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        if (timeoutInSeconds > 0L) {
            executor.setWatchdog(new ExecuteWatchdog(timeoutInSeconds * 1000L));
        }
        return executor;
    }

    protected void displayProcessOutputForException(ByteArrayOutputStream output, Logger logger) {
        String outputAsStr = output.toString();
        if (StringUtils.isNotBlank((CharSequence)outputAsStr)) {
            logger.error(outputAsStr);
        }
    }

    private static class LoggerOutputStream
    extends LogOutputStream {
        private final Logger logger;
        private static final String DEBUG_LOG = "DEBUG";
        private static final String WARNING_LOG = "WARNING";
        private static final String ERROR_LOG = "ERROR";
        private static final String CRITICAL_LOG = "CRITICAL";
        private static final String FAILURE_LOG = "FAILURE";

        LoggerOutputStream(Logger logger, int logLevel) {
            super(logLevel);
            this.logger = logger;
        }

        public final void flush() {
        }

        protected void processLine(String line, int logLevel) {
            String upperLine = line.toUpperCase();
            if (upperLine.contains(ERROR_LOG) || upperLine.contains(CRITICAL_LOG) || upperLine.contains(FAILURE_LOG)) {
                this.logger.error(line);
            } else if (upperLine.contains(WARNING_LOG)) {
                this.logger.warn(line);
            } else if (upperLine.contains(DEBUG_LOG)) {
                this.logger.debug(line);
            } else {
                this.logger.info(line);
            }
        }
    }
}

