/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.habushu.exec.Platform;
import org.technologybrewery.habushu.exec.ProcessExecutor;

public class PoetryCommandHelper {
    private static final String POETRY_COMMAND = "poetry";
    private static final Logger logger = LoggerFactory.getLogger(PoetryCommandHelper.class);
    private static final String extractVersionRegex = "[^0-9\\.]";
    private File workingDirectory;

    public PoetryCommandHelper(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public Pair<Boolean, String> getIsPoetryInstalledAndVersion() {
        try {
            ProcessExecutor executor = this.createPoetryExecutor(Arrays.asList("--version"));
            String versionResult = executor.executeAndGetResult(logger);
            String version = versionResult.replaceAll(extractVersionRegex, "");
            return new ImmutablePair((Object)true, (Object)version);
        }
        catch (Throwable e) {
            return new ImmutablePair((Object)false, null);
        }
    }

    public String getPoetryCacheDirectoryPath() throws MojoExecutionException {
        return this.execute(Arrays.asList("config", "cache-dir"));
    }

    public boolean isDependencyInstalled(String packageName) {
        try {
            this.execute(Arrays.asList("show", packageName));
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public void installDevelopmentDependency(String packageName) throws MojoExecutionException {
        this.execute(Arrays.asList("add", packageName, "--group", "dev"));
    }

    public String execute(List<String> arguments) throws MojoExecutionException {
        if (logger.isInfoEnabled()) {
            logger.info("Executing Poetry command: {} {}", (Object)POETRY_COMMAND, (Object)StringUtils.join(arguments, (String)" "));
        }
        ProcessExecutor executor = this.createPoetryExecutor(arguments);
        return executor.executeAndGetResult(logger);
    }

    public int executeAndLogOutput(List<String> arguments) throws MojoExecutionException {
        if (logger.isInfoEnabled()) {
            logger.info("Executing Poetry command: {} {}", (Object)POETRY_COMMAND, (Object)StringUtils.join(arguments, (String)" "));
        }
        ProcessExecutor executor = this.createPoetryExecutor(arguments);
        return executor.executeAndRedirectOutput(logger);
    }

    public void executeAndLogOutput(List<String> arguments, Map<String, String> environmentVariables) {
        if (logger.isInfoEnabled()) {
            logger.info("Executing Poetry command: {} {}", (Object)POETRY_COMMAND, (Object)StringUtils.join(arguments, (String)" "));
        }
        ProcessExecutor executor = this.createPoetryExecutor(arguments, environmentVariables);
        executor.executeAndRedirectOutput(logger);
    }

    public int executeWithSensitiveArgsAndLogOutput(List<Pair<String, Boolean>> argAndIsSensitivePairs) throws MojoExecutionException {
        if (logger.isInfoEnabled()) {
            List argsWithSensitiveArgsMasked = argAndIsSensitivePairs.stream().map(pair -> (Boolean)pair.getRight() != false ? "XXXX" : (String)pair.getLeft()).collect(Collectors.toList());
            logger.info("Executing Poetry command: {} {}", (Object)POETRY_COMMAND, (Object)StringUtils.join(argsWithSensitiveArgsMasked, (String)" "));
        }
        ProcessExecutor executor = this.createPoetryExecutor(argAndIsSensitivePairs.stream().map(Pair::getLeft).collect(Collectors.toList()));
        return executor.executeAndRedirectOutput(logger);
    }

    public Integer executePoetryCommandAndLogAfterTimeout(List<String> arguments, int timeout, TimeUnit timeUnit) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Integer> future = executor.submit(() -> this.executeAndLogOutput(arguments));
        try {
            Integer n = future.get(timeout, timeUnit);
            return n;
        }
        catch (TimeoutException e) {
            logger.warn("poetry " + String.join((CharSequence)" ", arguments) + " has been running for quite some time, you may want to quit the mvn process (Ctrl+c) and run \"poetry cache clear . --all\" and restart your build.");
            try {
                Integer n = future.get();
                return n;
            }
            catch (InterruptedException | ExecutionException e1) {
                throw new RuntimeException("Error occurred while waiting for Poetry command to complete", e1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error occurred while performing Poetry command: poetry %s", StringUtils.join(arguments, (String)" ")), e);
        }
        finally {
            executor.shutdown();
        }
    }

    public int installPoetryPlugin(String name) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("self");
        args.add("add");
        args.add(name);
        return this.executeAndLogOutput(args);
    }

    protected ProcessExecutor createPoetryExecutor(List<String> arguments) {
        ArrayList<String> fullCommandArgs = new ArrayList<String>();
        fullCommandArgs.add(POETRY_COMMAND);
        fullCommandArgs.addAll(arguments);
        return new ProcessExecutor(this.workingDirectory, fullCommandArgs, Platform.guess(), null);
    }

    protected ProcessExecutor createPoetryExecutor(List<String> arguments, Map<String, String> environmentVariables) {
        ArrayList<String> fullCommandArgs = new ArrayList<String>();
        fullCommandArgs.add(POETRY_COMMAND);
        fullCommandArgs.addAll(arguments);
        return new ProcessExecutor(this.workingDirectory, fullCommandArgs, Platform.guess(), environmentVariables);
    }
}

