/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu.exec;

import java.io.File;
import org.technologybrewery.habushu.exec.Architecture;
import org.technologybrewery.habushu.exec.OS;

public class Platform {
    private final OS os;
    private final Architecture architecture;
    private final String classifier;

    public Platform(OS os, Architecture architecture) {
        this(os, architecture, null);
    }

    public Platform(OS os, Architecture architecture, String classifier) {
        this.os = os;
        this.architecture = architecture;
        this.classifier = classifier;
    }

    public static Platform guess() {
        OS os = OS.guess();
        Architecture architecture = Architecture.guess();
        if (os == OS.Linux && new File("/etc/alpine-release").exists()) {
            return new Platform(os, architecture, "musl");
        }
        return new Platform(os, architecture);
    }

    public String getArchiveExtension() {
        return this.os.getArchiveExtension();
    }

    public String getCodename() {
        return this.os.getCodename();
    }

    public boolean isWindows() {
        return this.os == OS.Windows;
    }

    public boolean isMac() {
        return this.os == OS.Mac;
    }
}

