/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.technologybrewery.habushu.AbstractHabushuMojo;
import org.technologybrewery.habushu.PyenvAndPoetrySetup;

@Mojo(name="validate-pyenv-and-poetry", defaultPhase=LifecyclePhase.VALIDATE)
public class ValidatePyenvAndPoetryMojo
extends AbstractHabushuMojo {
    @Parameter(defaultValue="3.11.4", property="habushu.pythonVersion")
    protected String pythonVersion;
    @Parameter(defaultValue="true", property="habushu.usePyenv")
    protected boolean usePyenv;
    @Parameter(defaultValue="${project.build.directory}/pyenv-patch-install-python-version.sh", readonly=true)
    private File patchInstallScript;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        PyenvAndPoetrySetup configureTools = new PyenvAndPoetrySetup(this.pythonVersion, this.usePyenv, this.patchInstallScript, this.getPoetryProjectBaseDir(), this.rewriteLocalPathDepsInArchives, this.getLog());
        configureTools.execute();
        this.configurePriavtePyPiRepositoryCredentials(configureTools);
        this.configurePrivateDevPyPiRepositoryCredentials(configureTools);
        configureTools.installPoetryMonorepoDependencyPlugin();
    }

    private void configurePrivateDevPyPiRepositoryCredentials(PyenvAndPoetrySetup configureTools) throws MojoExecutionException {
        if (this.useDevRepository) {
            if (!"https://test.pypi.org/".equals(this.devRepositoryUrl)) {
                String pypiDevRepoIdUsername = this.findUsernameForServer(this.devRepositoryId);
                String pypiDevRepoIdPassword = this.findPasswordForServer(this.devRepositoryId);
                configureTools.registerRepositoryToSupportAuthenticatedDependencyResolution(this.devRepositoryId, pypiDevRepoIdUsername, pypiDevRepoIdPassword);
            } else {
                this.logSkipRationale(this.devRepositoryUrl);
            }
        }
    }

    private void configurePriavtePyPiRepositoryCredentials(PyenvAndPoetrySetup configureTools) throws MojoExecutionException {
        if (StringUtils.isNotEmpty((String)this.pypiRepoUrl) && !"https://pypi.org".equals(this.pypiRepoUrl)) {
            String pypiRepoIdUsername = this.findUsernameForServer(this.pypiRepoId);
            String pypiRepoIdPassword = this.findPasswordForServer(this.pypiRepoId);
            configureTools.registerRepositoryToSupportAuthenticatedDependencyResolution(this.pypiRepoId, pypiRepoIdUsername, pypiRepoIdPassword);
        } else {
            this.logSkipRationale(this.pypiRepoUrl);
        }
    }

    private void logSkipRationale(String repositoryUrl) {
        this.getLog().debug((CharSequence)("Skipping configuration for pulling from public readable repo: " + repositoryUrl));
    }
}

