/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.technologybrewery.habushu.AbstractHabushuMojo;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.WheelDependency;
import org.technologybrewery.habushu.util.HabushuUtil;

@Deprecated
@Mojo(name="retrieve-wheels", defaultPhase=LifecyclePhase.VALIDATE)
public class RetrieveWheelsMojo
extends AbstractHabushuMojo {
    @Parameter(property="habushu.wheelDependencies", required=false)
    protected List<WheelDependency> wheelDependencies;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.doExecute();
    }

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().warn((CharSequence)"The cache-wheels goal has been deperecated,please see the containerize-dependencies goal instead.");
        if (!this.wheelDependencies.isEmpty()) {
            this.processWheelDependencies();
        }
    }

    protected void processWheelDependencies() {
        this.getLog().info((CharSequence)String.format("Processing %s Wheel Dependencies..", this.wheelDependencies.size()));
        try {
            for (WheelDependency wd : this.wheelDependencies) {
                File poetryCacheWheelDirectory = this.getCachedWheelDirectory(wd.getArtifactId());
                String targetDirectory = wd.getTargetDirectory();
                if (poetryCacheWheelDirectory.exists()) {
                    List wheelFiles = Stream.of(poetryCacheWheelDirectory.listFiles()).filter(file -> file.getAbsolutePath().endsWith(".whl")).map(File::getAbsoluteFile).collect(Collectors.toList());
                    if (wheelFiles.size() == 0) {
                        this.getLog().warn((CharSequence)String.format("Did not find any %s wheels in poetry cache.", wd.getArtifactId()));
                        this.getLog().warn((CharSequence)"Consider using the `cacheWheel` configuration to cache the wheel artifact before depending on it.");
                        continue;
                    }
                    for (File file2 : wheelFiles) {
                        HabushuUtil.copyFile(file2.getPath(), String.format("%s/%s", targetDirectory, file2.getName()));
                        this.getLog().info((CharSequence)String.format("Retrieved the cached %s file", file2.getName()));
                    }
                    continue;
                }
                this.getLog().warn((CharSequence)String.format("Could not locate %s in poetry cache.", wd.getArtifactId()));
                this.getLog().warn((CharSequence)"Consider using the `cacheWheel` configuration to cache the wheel artifact before depending on it.");
            }
        }
        catch (Exception e) {
            throw new HabushuException("Could not process Wheel Dependencies!", e);
        }
    }

    protected File getProjectBuildDirectory() {
        return new File(this.project.getBuild().getDirectory());
    }
}

