/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.technologybrewery.habushu.ValidationTrackingStatus;
import org.technologybrewery.habushu.exec.PoetryCommandHelper;
import org.technologybrewery.habushu.exec.PyenvCommandHelper;
import org.technologybrewery.habushu.exec.PythonVersionHelper;

public class PyenvAndPoetrySetup {
    static final String PYTHON_DEFAULT_VERSION_REQUIREMENT = "3.11.4";
    private static final ThreadLocal<ValidationTrackingStatus> validationStatusContainer = ThreadLocal.withInitial(ValidationTrackingStatus::new);
    public static final String VALIDATED_IN_PRIOR_BUILD_PHASE = " (validated in prior build phase)";
    protected String pythonVersion;
    protected boolean usePyenv;
    protected File baseDir;
    protected boolean rewriteLocalPathDepsInArchives;
    protected Log log;
    private File patchInstallScript;

    public PyenvAndPoetrySetup(String pythonVersion, boolean usePyenv, File patchInstallScript, File baseDir, boolean rewriteLocalPathDepsInArchives, Log log) {
        this.pythonVersion = pythonVersion;
        this.usePyenv = usePyenv;
        this.patchInstallScript = patchInstallScript;
        this.baseDir = baseDir;
        this.rewriteLocalPathDepsInArchives = rewriteLocalPathDepsInArchives;
        this.log = log;
    }

    public void execute() throws MojoExecutionException {
        ArrayList<String> missingRequiredToolMsgs = new ArrayList<String>();
        ValidationTrackingStatus validationTracker = validationStatusContainer.get();
        String priorActivePythonVersionActivated = validationTracker.getPriorActivePythonVersionActivated();
        if (this.pythonVersion.equals(priorActivePythonVersionActivated)) {
            this.log.info((CharSequence)("Using Python version: " + priorActivePythonVersionActivated + VALIDATED_IN_PRIOR_BUILD_PHASE));
        } else {
            String currentPythonVersion = "";
            currentPythonVersion = this.usePyenv ? this.validateAndConfigurePyenv(missingRequiredToolMsgs, currentPythonVersion) : this.validateAndConfigureStraightPython();
            this.validatePythonVersion(currentPythonVersion);
            validationTracker.setPriorActivePythonVersionActivated(currentPythonVersion);
        }
        PoetryCommandHelper poetryHelper = this.createPoetryCommandHelper();
        Object alreadyValidatedPoetryVersion = validationTracker.getAlreadyValidatedPoetryVersion();
        if (!validationTracker.isAlreadyValidatedPoetryInstallation()) {
            this.log.debug((CharSequence)"Checking if Poetry is installed...");
            Pair<Boolean, String> poetryInstallStatusAndVersion = poetryHelper.getIsPoetryInstalledAndVersion();
            if (!((Boolean)poetryInstallStatusAndVersion.getLeft()).booleanValue()) {
                missingRequiredToolMsgs.add("'poetry' is not currently installed! Execute 'curl -sSL https://install.python-poetry.org | python -' to install or visit https://python-poetry.org/ for more information and installation options");
            } else {
                Semver poetryVersionSemver = new Semver((String)poetryInstallStatusAndVersion.getRight(), Semver.SemverType.NPM);
                if (!poetryVersionSemver.satisfies("^1.5.0")) {
                    missingRequiredToolMsgs.add(String.format("Poetry version %s was installed - Habushu requires that installed version of Poetry satisfies %s.  Please update Poetry by executing 'poetry self update' or visit https://python-poetry.org/docs/#installation for more information", poetryInstallStatusAndVersion.getRight(), "^1.5.0"));
                } else {
                    alreadyValidatedPoetryVersion = (String)poetryInstallStatusAndVersion.getRight();
                    validationTracker.setAlreadyValidatedPoetryVersion((String)alreadyValidatedPoetryVersion);
                    validationTracker.setAlreadyValidatedPoetryInstallation(true);
                }
            }
        } else {
            alreadyValidatedPoetryVersion = (String)alreadyValidatedPoetryVersion + VALIDATED_IN_PRIOR_BUILD_PHASE;
        }
        this.log.info((CharSequence)("Found Poetry " + (String)alreadyValidatedPoetryVersion));
        if (!missingRequiredToolMsgs.isEmpty()) {
            throw new MojoExecutionException(StringUtils.join((Object[])new Object[]{System.lineSeparator(), missingRequiredToolMsgs, System.lineSeparator()}));
        }
        String poetryTomlPath = this.baseDir.getAbsolutePath() + "/poetry.toml";
        File poetryToml = new File(poetryTomlPath);
        if (!poetryToml.exists()) {
            this.log.warn((CharSequence)"Did not find a poetry.toml within the current project. It is recommended to always include this file in version control to ensure consistent builds.");
        }
        if (this.usePyenv) {
            this.log.info((CharSequence)"Configuring Poetry to use the pyenv-activated Python binary...");
            poetryHelper.executeAndLogOutput(Arrays.asList("config", "--local", "virtualenvs.prefer-active-python", "true"));
        }
    }

    void installPoetryMonorepoDependencyPlugin() throws MojoExecutionException {
        PoetryCommandHelper poetryHelper = this.createPoetryCommandHelper();
        this.log.info((CharSequence)"Checking for updates to poetry-monorepo-dependency-plugin...");
        poetryHelper.installPoetryPlugin("poetry-monorepo-dependency-plugin@latest");
    }

    void registerRepositoryToSupportAuthenticatedDependencyResolution(String repoId, String username, String password) throws MojoExecutionException {
        PoetryCommandHelper poetryHelper = this.createPoetryCommandHelper();
        if (StringUtils.isEmpty((CharSequence)username) || StringUtils.isEmpty((CharSequence)password)) {
            this.log.info((CharSequence)String.format("Did not find username and password for the server with <id> %s. Will use existing configuration.", repoId));
        } else {
            String configKey = String.format("http-basic.%s", repoId);
            this.log.info((CharSequence)String.format("Adding username and password configuration for %s", repoId));
            ArrayList<Pair<String, Boolean>> credentialConfigurationArgs = new ArrayList<Pair<String, Boolean>>();
            credentialConfigurationArgs.add((Pair<String, Boolean>)new ImmutablePair((Object)"config", (Object)false));
            credentialConfigurationArgs.add((Pair<String, Boolean>)new ImmutablePair((Object)configKey, (Object)false));
            credentialConfigurationArgs.add((Pair<String, Boolean>)new ImmutablePair((Object)username, (Object)false));
            credentialConfigurationArgs.add((Pair<String, Boolean>)new ImmutablePair((Object)password, (Object)true));
            poetryHelper.executeWithSensitiveArgsAndLogOutput(credentialConfigurationArgs);
        }
    }

    private void validatePythonVersion(String currentPythonVersion) throws MojoExecutionException {
        if (StringUtils.isNotBlank((CharSequence)currentPythonVersion)) {
            if (!currentPythonVersion.equals(this.pythonVersion)) {
                throw new MojoExecutionException(String.format("Expected Python version %s, but found version %s", this.pythonVersion, currentPythonVersion));
            }
            String sourceMessage = this.usePyenv ? "(managed by pyenv)" : "(managed by the operating system)";
            this.log.info((CharSequence)String.format("Using Python %s %s", currentPythonVersion, sourceMessage));
        }
    }

    private String validateAndConfigureStraightPython() throws MojoExecutionException {
        String currentPythonVersion;
        PythonVersionHelper pythonVersionHelper = new PythonVersionHelper(this.baseDir, this.pythonVersion);
        try {
            currentPythonVersion = pythonVersionHelper.getCurrentPythonVersion();
        }
        catch (MojoExecutionException mojoExecutionException) {
            throw new MojoExecutionException("Expected Python version " + this.pythonVersion + ", but it was not installed");
        }
        return currentPythonVersion;
    }

    private String validateAndConfigurePyenv(List<String> missingRequiredToolMsgs, String currentPythonVersion) throws MojoExecutionException {
        PyenvCommandHelper pyenvHelper = this.createPyenvCommandHelper();
        this.log.debug((CharSequence)"Checking if pyenv is installed...");
        if (!pyenvHelper.isPyenvInstalled()) {
            missingRequiredToolMsgs.add("'pyenv' is not currently installed! Please install pyenv and try again. Visit https://github.com/pyenv/pyenv for more information.");
        } else {
            PythonVersionHelper pythonVersionHelper;
            String postPyenvActivatedPythonVersion;
            currentPythonVersion = pyenvHelper.getCurrentPythonVersion();
            if (!this.pythonVersion.equals(currentPythonVersion)) {
                pyenvHelper.updatePythonVersion(this.pythonVersion, this.patchInstallScript);
                currentPythonVersion = pyenvHelper.getCurrentPythonVersion();
            }
            if (!this.pythonVersion.equals(postPyenvActivatedPythonVersion = (pythonVersionHelper = new PythonVersionHelper(this.baseDir, this.pythonVersion)).getCurrentPythonVersion())) {
                missingRequiredToolMsgs.add(String.format("Expected 'pyenv' to set Python to %s but instead found %s!", this.pythonVersion, postPyenvActivatedPythonVersion));
                missingRequiredToolMsgs.add("'pyenv' is installed, but not configured correctly.  Ensure your PATH includes 'pyenv init -' expected content OR do not configure habushu to use 'pyenv' to manage the Python version!");
            }
            this.log.debug((CharSequence)"pyenv already installed");
        }
        return currentPythonVersion;
    }

    protected PyenvCommandHelper createPyenvCommandHelper() {
        return new PyenvCommandHelper(this.baseDir);
    }

    protected PoetryCommandHelper createPoetryCommandHelper() {
        return new PoetryCommandHelper(this.baseDir);
    }
}

