/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import com.google.common.base.Predicates;
import io.github.itning.retry.RetryException;
import io.github.itning.retry.Retryer;
import io.github.itning.retry.RetryerBuilder;
import io.github.itning.retry.strategy.stop.StopStrategies;
import io.github.itning.retry.strategy.stop.StopStrategy;
import io.github.itning.retry.strategy.wait.WaitStrategies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.technologybrewery.habushu.AbstractHabushuMojo;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.exec.PoetryCommandHelper;

@Mojo(name="publish-to-pypi-repo", defaultPhase=LifecyclePhase.DEPLOY)
public class PublishToPyPiRepoMojo
extends AbstractHabushuMojo {
    private static final String VERSION = "version";
    @Parameter(property="habushu.snapshotNumberDateFormatPattern")
    protected String snapshotNumberDateFormatPattern;
    @Parameter(property="habushu.skipDeploy", defaultValue="false")
    protected boolean skipDeploy;
    @Parameter(property="habushu.pypiUploadSuffix", defaultValue="")
    protected String pypiUploadSuffix = "";
    @Parameter(property="habushu.devRepositoryUrlUploadSuffix", defaultValue="legacy/")
    protected String devRepositoryUrlUploadSuffix;
    @Parameter(property="habushu.pyPiPushRetries", defaultValue="3")
    protected int pypiPushRetries = 3;
    @Parameter(property="habushu.pypiPushRetryMultiplier", defaultValue="15000")
    protected long pypiPushRetryMultiplier;
    @Parameter(property="habushu.pypiPushRetryMaxTimeout", defaultValue="3")
    protected long pypiPushRetryMaxTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        block4: {
            PoetryCommandHelper poetryHelper;
            block3: {
                if (this.skipDeploy) {
                    this.getLog().info((CharSequence)String.format("Skipping deploy phase - package for %s will not be published to the configured PyPI repository", this.project.getId()));
                    return;
                }
                poetryHelper = this.createPoetryCommandHelper();
                String pomVersion = this.project.getVersion();
                if (!this.overridePackageVersion || !PublishToPyPiRepoMojo.isPomVersionSnapshot(pomVersion)) break block3;
                String currentPythonPackageVersion = poetryHelper.execute(Arrays.asList(VERSION, "-s"));
                String snapshotVersionToPublish = PublishToPyPiRepoMojo.getPythonPackageVersion(pomVersion, true, this.snapshotNumberDateFormatPattern);
                try {
                    this.getLog().info((CharSequence)String.format("Setting version of Poetry package to publish to %s", snapshotVersionToPublish));
                    poetryHelper.executeAndLogOutput(Arrays.asList(VERSION, snapshotVersionToPublish));
                    this.publishPackage(poetryHelper, true);
                }
                catch (Throwable throwable) {
                    this.getLog().info((CharSequence)String.format("Resetting Poetry package version back to %s", currentPythonPackageVersion));
                    poetryHelper.executeAndLogOutput(Arrays.asList(VERSION, currentPythonPackageVersion));
                    throw throwable;
                }
                this.getLog().info((CharSequence)String.format("Resetting Poetry package version back to %s", currentPythonPackageVersion));
                poetryHelper.executeAndLogOutput(Arrays.asList(VERSION, currentPythonPackageVersion));
                break block4;
            }
            this.publishPackage(poetryHelper, false);
        }
    }

    protected void publishPackage(PoetryCommandHelper poetryHelper, boolean rebuildPackage) throws MojoExecutionException {
        String repoUrl;
        String repoId;
        boolean publishToDev;
        boolean bl = publishToDev = rebuildPackage && this.useDevRepository;
        if (publishToDev) {
            this.getLog().info((CharSequence)"Publishing to dev repository (useDevRepository=true, dev version being published)");
        }
        String username = null;
        String password = null;
        String string = repoId = publishToDev ? this.devRepositoryId : this.pypiRepoId;
        if (StringUtils.isNotEmpty((CharSequence)repoId)) {
            username = this.findUsernameForServer(repoId);
            password = this.findPasswordForServer(repoId);
        }
        if (StringUtils.isNotEmpty((CharSequence)(repoUrl = this.getRepositoryUrl(publishToDev)))) {
            if (StringUtils.isEmpty((CharSequence)username) || StringUtils.isEmpty((CharSequence)password)) {
                throw new MojoExecutionException(String.format("Please ensure that both <username> and <password> are provided for the <server> with <id> %s in your settings.xml configuration!", repoId));
            }
            this.getLog().info((CharSequence)String.format("Adding repository configuration to poetry.toml for %s at %s", repoId, repoUrl));
            poetryHelper.execute(Arrays.asList("config", "--local", String.format("repositories.%s", repoId), repoUrl));
        }
        List<Pair<String, Boolean>> publishToRepoWithCredsArgs = Collections.emptyList();
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            publishToRepoWithCredsArgs = new ArrayList();
            if (!"pypi".equals(repoId)) {
                publishToRepoWithCredsArgs.add((Pair<String, Boolean>)new ImmutablePair((Object)"--repository", (Object)false));
                publishToRepoWithCredsArgs.add((Pair<String, Boolean>)new ImmutablePair((Object)repoId, (Object)false));
            }
            publishToRepoWithCredsArgs.add((Pair<String, Boolean>)new ImmutablePair((Object)"--username", (Object)false));
            publishToRepoWithCredsArgs.add((Pair<String, Boolean>)new ImmutablePair((Object)username, (Object)false));
            publishToRepoWithCredsArgs.add((Pair<String, Boolean>)new ImmutablePair((Object)"--password", (Object)false));
            publishToRepoWithCredsArgs.add((Pair<String, Boolean>)new ImmutablePair((Object)password, (Object)true));
        }
        String publishCommand = this.rewriteLocalPathDepsInArchives ? "publish-rewrite-path-deps" : "publish";
        this.getLog().info((CharSequence)String.format("Publishing archives to %s %s", StringUtils.isNotEmpty((CharSequence)repoUrl) ? repoUrl : "official PyPI repository", this.rewriteLocalPathDepsInArchives ? "with poetry-monorepo-dependency-plugin" : ""));
        if (!publishToRepoWithCredsArgs.isEmpty()) {
            publishToRepoWithCredsArgs.add(0, (Pair<String, Boolean>)new ImmutablePair((Object)publishCommand, (Object)false));
            if (rebuildPackage) {
                publishToRepoWithCredsArgs.add(1, (Pair<String, Boolean>)new ImmutablePair((Object)"--build", (Object)false));
            }
        } else {
            this.getLog().warn((CharSequence)String.format("PyPI repository credentials not specified in <server> element in settings.xml with <id> of %s", "pypi"));
            this.getLog().warn((CharSequence)"Please populate settings.xml with PyPI credentials or ensure that Poetry is manually configured with the correct PyPI credentials (i.e. poetry config pypi-token.pypi my-token)");
            publishToRepoWithCredsArgs.add((Pair<String, Boolean>)new ImmutablePair((Object)publishCommand, (Object)false));
            if (rebuildPackage) {
                publishToRepoWithCredsArgs.add((Pair<String, Boolean>)new ImmutablePair((Object)"--build", (Object)false));
            }
        }
        this.invokePublish(poetryHelper, publishToRepoWithCredsArgs);
    }

    protected void invokePublish(PoetryCommandHelper poetryHelper, List<Pair<String, Boolean>> publishToRepoWithCredsArgs) {
        Callable<Boolean> callable = this.getPyPiPushCallable(poetryHelper, publishToRepoWithCredsArgs);
        Retryer<Boolean> retryer = this.getRetryer();
        try {
            Boolean result = (Boolean)retryer.call(callable);
            if (Boolean.FALSE.equals(result)) {
                throw new HabushuException("Push to PyPI repository failed!");
            }
        }
        catch (RetryException e) {
            throw new HabushuException("Exceeded retry setting of: " + this.pypiPushRetries, e);
        }
        catch (ExecutionException e) {
            throw new HabushuException("Could not execute PyPI push!", e);
        }
    }

    protected Callable<Boolean> getPyPiPushCallable(final PoetryCommandHelper poetryHelper, final List<Pair<String, Boolean>> publishToRepoWithCredsArgs) {
        Callable<Boolean> callable = new Callable<Boolean>(){
            private boolean firstAttempt = true;

            @Override
            public Boolean call() throws Exception {
                if (!this.firstAttempt) {
                    publishToRepoWithCredsArgs.removeIf(arg -> "--build".equals(arg.getLeft()));
                    PublishToPyPiRepoMojo.this.getLog().debug((CharSequence)"Removing build command from retry due to the general issue error described in https://github.com/python-poetry/cleo/issues/351");
                } else {
                    this.firstAttempt = false;
                }
                int result = poetryHelper.executeWithSensitiveArgsAndLogOutput(publishToRepoWithCredsArgs);
                if (result != 0) {
                    PublishToPyPiRepoMojo.this.getLog().warn((CharSequence)("PyPI Publish process result code: " + result));
                }
                return result == 0;
            }
        };
        return callable;
    }

    protected Retryer<Boolean> getRetryer() {
        RetryerBuilder retryBuilder = RetryerBuilder.newBuilder();
        if (this.pypiPushRetries != 0) {
            StopStrategy stopStrategy = this.pypiPushRetries < 0 ? StopStrategies.neverStop() : StopStrategies.stopAfterAttempt((int)this.pypiPushRetries);
            retryBuilder.retryIfResult((Predicate)Predicates.equalTo((Object)Boolean.FALSE)).retryIfRuntimeException().withStopStrategy(stopStrategy).withWaitStrategy(WaitStrategies.fibonacciWait((long)this.pypiPushRetryMultiplier, (long)this.pypiPushRetryMaxTimeout, (TimeUnit)TimeUnit.MINUTES));
        }
        return retryBuilder.build();
    }

    String getRepositoryUrl(boolean publishToDev) {
        Object repoUrl = PublishToPyPiRepoMojo.addTrailingSlash(this.pypiRepoUrl);
        if (publishToDev) {
            repoUrl = PublishToPyPiRepoMojo.addTrailingSlash(this.devRepositoryUrl) + PublishToPyPiRepoMojo.addTrailingSlash(this.devRepositoryUrlUploadSuffix);
        } else if (!StringUtils.isEmpty((CharSequence)this.pypiUploadSuffix)) {
            repoUrl = (String)repoUrl + PublishToPyPiRepoMojo.addTrailingSlash(this.pypiUploadSuffix);
        }
        return repoUrl;
    }

    static String addTrailingSlash(String inputUrl) {
        if (StringUtils.isNotBlank((CharSequence)inputUrl) && !StringUtils.endsWith((CharSequence)inputUrl, (CharSequence)"/")) {
            inputUrl = (String)inputUrl + "/";
        }
        return inputUrl;
    }
}

