/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.vdurmont.semver4j.Semver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.technologybrewery.habushu.AbstractHabushuMojo;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.PackageDefinition;
import org.technologybrewery.habushu.exec.PoetryCommandHelper;
import org.technologybrewery.habushu.util.TomlReplacementTuple;
import org.technologybrewery.habushu.util.TomlUtils;

@Mojo(name="install-dependencies", defaultPhase=LifecyclePhase.COMPILE)
public class InstallDependenciesMojo
extends AbstractHabushuMojo {
    private static final String EQUALS = "=";
    @Parameter(defaultValue="true", property="habushu.addPypiRepoAsPackageSources")
    private boolean addPypiRepoAsPackageSources;
    @Parameter(property="habushu.pypiSimpleSuffix", defaultValue="simple")
    private String pypiSimpleSuffix;
    @Parameter(defaultValue="false", property="habushu.skipPoetryLockUpdate")
    private boolean skipPoetryLockUpdate;
    protected static final String PYPROJECT_PACKAGE_SOURCES_PATH = "tool.poetry.source";
    @Parameter(property="habushu.withGroups")
    private String[] withGroups;
    @Parameter(property="habushu.withoutGroups")
    private String[] withoutGroups;
    @Parameter(defaultValue="false", property="habushu.forceSync")
    private boolean forceSync;
    @Parameter(property="habushu.managedDependencies")
    protected List<PackageDefinition> managedDependencies;
    @Parameter(defaultValue="true", property="habushu.updateManagedDependenciesWhenFound")
    protected boolean updateManagedDependenciesWhenFound;
    @Parameter(defaultValue="false", property="habushu.failOnManagedDependenciesMismatches")
    protected boolean failOnManagedDependenciesMismatches;
    @Parameter(defaultValue="true", property="habushu.useInProjectVirtualEnvironment")
    protected boolean useInProjectVirtualEnvironment;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        PoetryCommandHelper poetryHelper = this.createPoetryCommandHelper();
        this.setUpInProjectVirtualEnvironment(poetryHelper);
        this.processManagedDependencyMismatches();
        this.prepareRepositoryForInstallation(this.pypiRepoId, this.pypiRepoUrl);
        if (this.useDevRepository) {
            this.prepareRepositoryForInstallation(this.devRepositoryId, this.devRepositoryUrl);
        }
        if (!this.skipPoetryLockUpdate) {
            this.getLog().info((CharSequence)"Locking dependencies specified in pyproject.toml...");
            poetryHelper.executePoetryCommandAndLogAfterTimeout(Arrays.asList("lock"), 2, TimeUnit.MINUTES);
        }
        ArrayList<String> installCommand = new ArrayList<String>();
        installCommand.add("install");
        for (String groupName : this.withGroups) {
            installCommand.add("--with");
            installCommand.add(groupName);
        }
        for (String groupName : this.withoutGroups) {
            installCommand.add("--without");
            installCommand.add(groupName);
        }
        if (this.forceSync) {
            installCommand.add("--sync");
        }
        this.getLog().info((CharSequence)"Installing dependencies...");
        poetryHelper.executePoetryCommandAndLogAfterTimeout(installCommand, 2, TimeUnit.MINUTES);
    }

    private void setUpInProjectVirtualEnvironment(PoetryCommandHelper poetryHelper) throws MojoExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("config");
        arguments.add("virtualenvs.in-project");
        arguments.add("--local");
        String currentInProjectSetting = poetryHelper.execute(arguments);
        if (this.useInProjectVirtualEnvironment && Boolean.FALSE.equals(Boolean.valueOf(currentInProjectSetting))) {
            this.getLog().info((CharSequence)"Configuring Poetry to use an in-project virtual environment...");
            this.configureVirtualEnvironmentsInProject(true);
        } else if (!this.useInProjectVirtualEnvironment && Boolean.TRUE.equals(Boolean.valueOf(currentInProjectSetting))) {
            this.configureVirtualEnvironmentsInProject(false);
        }
    }

    private void configureVirtualEnvironmentsInProject(boolean enable) throws MojoExecutionException {
        PoetryCommandHelper poetryHelper = this.createPoetryCommandHelper();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("config");
        arguments.add("virtualenvs.in-project");
        arguments.add(Boolean.toString(enable));
        arguments.add("--local");
        poetryHelper.executeAndLogOutput(arguments);
    }

    private void prepareRepositoryForInstallation(String repoId, String repoUrl) throws MojoExecutionException {
        if (StringUtils.isNotEmpty((CharSequence)repoUrl) && this.addPypiRepoAsPackageSources) {
            Config matchingPypiRepoSourceConfig;
            String pypiRepoSimpleIndexUrl;
            try {
                pypiRepoSimpleIndexUrl = this.getPyPiRepoSimpleIndexUrl(repoUrl);
            }
            catch (URISyntaxException e) {
                throw new MojoExecutionException(String.format("Could not parse configured repoUrl %s", repoUrl), (Exception)e);
            }
            try (FileConfig pyProjectConfig = FileConfig.of((File)this.getPoetryPyProjectTomlFile());){
                pyProjectConfig.load();
                Optional packageSources = pyProjectConfig.getOptional(PYPROJECT_PACKAGE_SOURCES_PATH);
                matchingPypiRepoSourceConfig = packageSources.orElse(Collections.emptyList()).stream().filter(packageSource -> pypiRepoSimpleIndexUrl.equals(packageSource.get("url"))).findFirst().orElse(Config.inMemory());
            }
            if (!matchingPypiRepoSourceConfig.isEmpty()) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)String.format("Configured PyPi repository %s found in the following pyproject.toml [[%s]] array element: %s", repoUrl, PYPROJECT_PACKAGE_SOURCES_PATH, matchingPypiRepoSourceConfig));
                }
            } else {
                List<String> newPypiRepoSourceConfig = Arrays.asList(System.lineSeparator(), String.format("# Added by habushu-maven-plugin at %s to use %s as source PyPi repository for installing dependencies", LocalDateTime.now(), pypiRepoSimpleIndexUrl), String.format("[[%s]]", PYPROJECT_PACKAGE_SOURCES_PATH), String.format("name = \"%s\"", StringUtils.isNotEmpty((CharSequence)repoId) && !"pypi".equals(repoId) ? repoId : "private-pypi-repo"), String.format("url = \"%s\"", pypiRepoSimpleIndexUrl), "priority = \"supplemental\"");
                this.getLog().info((CharSequence)String.format("Private PyPi repository entry for %s not found in pyproject.toml", repoUrl));
                this.getLog().info((CharSequence)String.format("Adding %s to pyproject.toml as supplemental repository from which dependencies may be installed", pypiRepoSimpleIndexUrl));
                try {
                    Files.write(this.getPoetryPyProjectTomlFile().toPath(), newPypiRepoSourceConfig, StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(String.format("Could not write new [[%s]] element to pyproject.toml", PYPROJECT_PACKAGE_SOURCES_PATH), (Exception)e);
                }
            }
        }
    }

    protected String getPyPiRepoSimpleIndexUrl(String pypiRepoUrl) throws URISyntaxException {
        String lastPathSegment;
        URIBuilder pypiRepoUriBuilder = new URIBuilder(StringUtils.removeEnd((String)pypiRepoUrl, (String)"/"));
        ArrayList<String> repoUriPathSegments = pypiRepoUriBuilder.getPathSegments();
        String string = lastPathSegment = CollectionUtils.isNotEmpty((Collection)repoUriPathSegments) ? (String)repoUriPathSegments.get(repoUriPathSegments.size() - 1) : null;
        if (!this.pypiSimpleSuffix.equals(lastPathSegment)) {
            repoUriPathSegments = new ArrayList<String>(repoUriPathSegments);
            repoUriPathSegments.add(this.pypiSimpleSuffix);
            pypiRepoUriBuilder.setPathSegments(repoUriPathSegments);
        }
        return StringUtils.appendIfMissing((String)pypiRepoUriBuilder.build().toString(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    protected void processManagedDependencyMismatches() {
        if (!this.managedDependencies.isEmpty()) {
            HashMap<String, TomlReplacementTuple> replacements = new HashMap<String, TomlReplacementTuple>();
            try (FileConfig pyProjectConfig = FileConfig.of((File)this.getPoetryPyProjectTomlFile());){
                pyProjectConfig.load();
                this.executeDetailedManagedDependencyMismatchActions(replacements, pyProjectConfig, "tool.poetry.dependencies");
                this.executeDetailedManagedDependencyMismatchActions(replacements, pyProjectConfig, "tool.poetry.group.dev.dependencies");
                List<String> toolPoetryGroupSections = this.findCustomToolPoetryGroups();
                for (String toolPoetryGroupSection : toolPoetryGroupSections) {
                    this.executeDetailedManagedDependencyMismatchActions(replacements, pyProjectConfig, toolPoetryGroupSection);
                }
                if (this.failOnManagedDependenciesMismatches || !this.updateManagedDependenciesWhenFound) {
                    for (TomlReplacementTuple replacement : replacements.values()) {
                        this.logPackageMismatch(replacement.getPackageName(), replacement.getOriginalOperatorAndVersion(), replacement.getUpdatedOperatorAndVersion());
                    }
                }
                this.performPendingDependencyReplacements(replacements);
            }
        }
    }

    private void executeDetailedManagedDependencyMismatchActions(Map<String, TomlReplacementTuple> replacements, FileConfig pyProjectConfig, String tomlSection) {
        Optional toolPoetryDependencies = pyProjectConfig.getOptional(tomlSection);
        if (toolPoetryDependencies.isPresent()) {
            Config foundDependencies = (Config)toolPoetryDependencies.get();
            Map dependencyMap = foundDependencies.valueMap();
            for (PackageDefinition def : this.managedDependencies) {
                String packageName = def.getPackageName();
                if (!dependencyMap.containsKey(packageName)) continue;
                Object packageRhs = dependencyMap.get(packageName);
                if (TomlUtils.representsLocalDevelopmentVersion(packageRhs)) {
                    this.getLog().info((CharSequence)String.format("%s does not have a specific version to manage - skipping", packageName));
                    this.getLog().debug((CharSequence)String.format("\t %s", packageRhs.toString()));
                    continue;
                }
                this.performComparisonAndStageNeededChanges(replacements, def, packageRhs);
            }
        }
    }

    private void performComparisonAndStageNeededChanges(Map<String, TomlReplacementTuple> replacements, PackageDefinition def, Object packageRhs) {
        boolean mismatch;
        String originalOperatorAndVersion = this.getOperatorAndVersion(packageRhs);
        String updatedOperatorAndVersion = def.getOperatorAndVersion();
        String packageName = def.getPackageName();
        if (this.overridePackageVersion && updatedOperatorAndVersion.contains("-SNAPSHOT")) {
            Semver version = this.getPoetryVersion();
            updatedOperatorAndVersion = version.isGreaterThanOrEqualTo("1.5.0") && !updatedOperatorAndVersion.contains("^") ? InstallDependenciesMojo.replaceSnapshotWithWildcard(updatedOperatorAndVersion) : InstallDependenciesMojo.replaceSnapshotWithDev(updatedOperatorAndVersion);
        }
        boolean bl = mismatch = !originalOperatorAndVersion.equals(updatedOperatorAndVersion);
        if (mismatch) {
            if (def.isActive()) {
                TomlReplacementTuple tuple = new TomlReplacementTuple(packageName, originalOperatorAndVersion, updatedOperatorAndVersion);
                replacements.put(packageName, tuple);
            } else {
                this.getLog().info((CharSequence)String.format("Package %s is not up to date with common project package definition guidance, but the check has been inactivated", packageName));
            }
        }
    }

    protected Semver getPoetryVersion() {
        PoetryCommandHelper poetryHelper = this.createPoetryCommandHelper();
        Pair<Boolean, String> poetryStatus = poetryHelper.getIsPoetryInstalledAndVersion();
        String versionAsString = (String)poetryStatus.getRight();
        return new Semver(versionAsString);
    }

    private void logPackageMismatch(String packageName, String originalOperatorAndVersion, String updatedOperatorAndVersion) {
        this.getLog().warn((CharSequence)String.format("Package %s is not up to date with common project package definition guidance! Currently %s, but should be %s!", packageName, originalOperatorAndVersion, updatedOperatorAndVersion));
    }

    protected void performPendingDependencyReplacements(Map<String, TomlReplacementTuple> replacements) {
        if (MapUtils.isNotEmpty(replacements)) {
            if (this.failOnManagedDependenciesMismatches) {
                if (this.updateManagedDependenciesWhenFound) {
                    this.getLog().warn((CharSequence)"updateManagedDependenciesWhenFound=true will never be processed when failOnManagedDependenciesMismatches also equals true!");
                }
                throw new HabushuException("Found managed dependencies - please fix before proceeding!  (see 'Package abc is not up to date with common project package definition guidance!` log messages above!");
            }
            if (this.updateManagedDependenciesWhenFound) {
                File pyProjectTomlFile = this.getPoetryPyProjectTomlFile();
                Object fileContent = "";
                try (BufferedReader reader = new BufferedReader(new FileReader(pyProjectTomlFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        if (line.contains(" ") || line.contains(EQUALS)) {
                            TomlReplacementTuple matchedTuple;
                            String key = line.substring(0, line.indexOf(" "));
                            if (key == null) {
                                key = line.substring(0, line.indexOf(EQUALS));
                            }
                            if (key != null && (matchedTuple = replacements.get(key = key.strip())) != null) {
                                String original = TomlUtils.escapeTomlRightHandSide(matchedTuple.getOriginalOperatorAndVersion());
                                String updated = TomlUtils.escapeTomlRightHandSide(matchedTuple.getUpdatedOperatorAndVersion());
                                if (line.endsWith(original)) {
                                    line = line.replace(original, updated);
                                    this.getLog().info((CharSequence)String.format("Updated %s: %s --> %s", matchedTuple.getPackageName(), original, updated));
                                }
                            }
                        }
                        fileContent = (String)fileContent + line + "\n";
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    throw new HabushuException("Problem reading pyproject.toml to update with managed dependencies!", e);
                }
                try {
                    TomlUtils.writeTomlFile(pyProjectTomlFile, (String)fileContent);
                }
                catch (IOException e) {
                    throw new HabushuException("Problem writing pyproject.toml with managed dependency updates!", e);
                }
            }
        }
    }

    protected String getOperatorAndVersion(Object rawData) {
        String operatorAndVersion = null;
        if (rawData instanceof String) {
            operatorAndVersion = (String)rawData;
        } else if (rawData instanceof CommentedConfig) {
            operatorAndVersion = TomlUtils.convertCommentedConfigToToml((CommentedConfig)rawData);
        } else {
            this.getLog().warn((CharSequence)String.format("Could not process type %s - attempting to use toString() value!", rawData.getClass()));
            operatorAndVersion = rawData.toString();
        }
        return operatorAndVersion;
    }

    protected static String replaceSnapshotWithWildcard(String pomVersion) {
        return pomVersion.substring(0, pomVersion.indexOf("-SNAPSHOT")) + ".*";
    }

    @Deprecated
    protected static String replaceSnapshotWithDev(String pomVersion) {
        return pomVersion.substring(0, pomVersion.indexOf("-SNAPSHOT")) + ".dev";
    }
}

