/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.technologybrewery.habushu.AbstractHabushuMojo;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.exec.PoetryCommandHelper;

@Mojo(name="initialize-habushu", defaultPhase=LifecyclePhase.INITIALIZE)
public class InitializeHabushuMojo
extends AbstractHabushuMojo {
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Validating Poetry-based project structure...");
        PoetryCommandHelper poetryHelper = this.createPoetryCommandHelper();
        try {
            poetryHelper.execute(Arrays.asList("check"));
        }
        catch (HabushuException e) {
            this.getLog().debug((CharSequence)"Failure encountered while running 'poetry check'!", (Throwable)e);
            this.getLog().warn((CharSequence)"poetry check failed (debug contains more details) - this is likely due to a mismatch between your pyproject.toml and poetry.lock file - attempting to correct...");
            poetryHelper.execute(Arrays.asList("lock", "--no-update"));
            this.getLog().warn((CharSequence)"Corrected - pyproject.toml and poetry.lock now synced");
        }
        String currentPythonPackageVersion = poetryHelper.execute(Arrays.asList("version", "-s"));
        String pomVersion = this.project.getVersion();
        String expectedPythonPackageVersion = InitializeHabushuMojo.getPythonPackageVersion(pomVersion, false, null);
        if (!StringUtils.equals((CharSequence)currentPythonPackageVersion, (CharSequence)expectedPythonPackageVersion)) {
            if (this.overridePackageVersion) {
                this.getLog().info((CharSequence)String.format("Setting Poetry package version to %s", expectedPythonPackageVersion));
                this.getLog().info((CharSequence)"If you do *not* want the Poetry package version to be automatically synced with the POM version, set <overridePackageVersion>false</overridePackageVersion> in the plugin's <configuration>");
                poetryHelper.executeAndLogOutput(Arrays.asList("version", expectedPythonPackageVersion));
            } else {
                this.getLog().debug((CharSequence)String.format("Poetry package version set to %s in pyproject.toml does not align with expected POM-derived version of %s", currentPythonPackageVersion, expectedPythonPackageVersion));
            }
        }
    }
}

