/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.technologybrewery.habushu.AbstractHabushuMojo;
import org.technologybrewery.habushu.exec.PoetryCommandHelper;

@Mojo(name="format-python", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class FormatPythonMojo
extends AbstractHabushuMojo {
    protected static final String BLACK_PACKAGE = "black";

    @Override
    public void doExecute() throws MojoExecutionException {
        PoetryCommandHelper poetryHelper;
        ArrayList<String> directoriesToFormat = new ArrayList<String>();
        if (this.sourceDirectory.exists()) {
            directoriesToFormat.add(this.getCanonicalPathForFile(this.sourceDirectory));
        }
        if (this.testDirectory.exists()) {
            directoriesToFormat.add(this.getCanonicalPathForFile(this.testDirectory));
        }
        if (directoriesToFormat.isEmpty()) {
            this.getLog().warn((CharSequence)String.format("Neither configured source (%s) nor test (%s) directories exist - skipping...", this.sourceDirectory, this.testDirectory));
        }
        if (!(poetryHelper = this.createPoetryCommandHelper()).isDependencyInstalled(BLACK_PACKAGE)) {
            this.getLog().info((CharSequence)String.format("%s dependency not specified in pyproject.toml - installing now...", BLACK_PACKAGE));
            poetryHelper.installDevelopmentDependency(BLACK_PACKAGE);
        }
        ArrayList<String> executeBlackFormatterArgs = new ArrayList<String>();
        executeBlackFormatterArgs.addAll(Arrays.asList("run", BLACK_PACKAGE));
        executeBlackFormatterArgs.addAll(directoriesToFormat);
        this.getLog().info((CharSequence)"Formatting configured source and test directories using black...");
        poetryHelper.executeAndLogOutput(executeBlackFormatterArgs);
    }
}

