/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.habushu.AbstractHabushuMojo;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.util.ContainerizeDepsDockerfileHelper;

@Mojo(name="containerize-dependencies", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class ContainerizeDepsMojo
extends AbstractHabushuMojo {
    private static final Logger logger = LoggerFactory.getLogger(ContainerizeDepsMojo.class);
    @Component
    protected MavenSession session;
    @Parameter(defaultValue="${project.build.directory}/containerize-support", property="habushu.stagingDirectory")
    protected File stagingDirectory;
    @Parameter
    protected FileSet defaultSourceSet;
    @Parameter(defaultValue="true", property="habushu.updateDockerfile")
    protected boolean updateDockerfile;
    @Parameter(property="habushu.dockerfile")
    protected File dockerfile;
    @Parameter(defaultValue="${project.basedir}", property="habushu.dockerContext")
    protected File dockerContext;
    @Parameter(defaultValue="1001", property="habushu.dockerUser")
    protected String dockerUser;
    @Parameter(defaultValue="docker.io/python:3.11", property="habushu.dockerBuilderBase")
    protected String dockerBuilderBase;
    @Parameter(defaultValue="docker.io/python:3.11-slim", property="habushu.dockerFinalBase")
    protected String dockerFinalBase;
    protected final String HABUSHU = "habushu";

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.doExecute();
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        Path sourceRoot = Path.of(this.session.getExecutionRootDirectory(), new String[0]);
        ProjectCollectionResult result = this.getHabushuProjects();
        try {
            Path targetProjectPath = this.stageHabushuProjects(sourceRoot, result);
            if (this.updateDockerfile) {
                if (this.dockerfile == null) {
                    throw new HabushuException("`updateDockerfile` is set to true but `dockerfile` is not specified");
                }
                this.performDockerfileUpdateForVirtualEnvironment(targetProjectPath);
            }
        }
        catch (IOException e) {
            throw new HabushuException("Failed to prepare containerization of Habushu dependency", e);
        }
    }

    protected Path stageHabushuProjects(Path sourceRoot, ProjectCollectionResult projectCollection) throws IOException {
        Path destRoot = this.getStagingPath();
        Path primaryProjectPath = null;
        for (MavenProject project : projectCollection.getAllProjects()) {
            Path projectPath = project.getBasedir().toPath();
            Path relativeProjectPath = sourceRoot.relativize(projectPath);
            if (project.equals((Object)projectCollection.getPrimaryProject())) {
                primaryProjectPath = relativeProjectPath;
            }
            FileSet sourceFileSet = this.getSourceSet();
            sourceFileSet.setDirectory(projectPath.toString());
            this.stageSourcesForProject(sourceRoot, destRoot, sourceFileSet, relativeProjectPath);
        }
        if (primaryProjectPath == null) {
            throw new HabushuException("Primary project was not included in the set of projects. Ensure the Habushu project is in the build and the POM dependencies are configured correctly.");
        }
        return primaryProjectPath;
    }

    protected void stageSourcesForProject(Path sourceRoot, Path destRoot, FileSet sourceFileSet, Path relativeProjectPath) throws IOException {
        FileSetManager fileSetManager = new FileSetManager();
        logger.info("Staging {} monorepo dependency files from {}.", (Object)fileSetManager.getIncludedFiles(sourceFileSet).length, (Object)relativeProjectPath.getFileName());
        for (String includedFile : fileSetManager.getIncludedFiles(sourceFileSet)) {
            Path relativeFilePath = relativeProjectPath.resolve(includedFile);
            Files.createDirectories(destRoot.resolve(relativeFilePath).getParent(), new FileAttribute[0]);
            Files.copy(sourceRoot.resolve(relativeFilePath), destRoot.resolve(relativeFilePath), new CopyOption[0]);
        }
    }

    protected FileSet getSourceSet() {
        if (this.defaultSourceSet != null) {
            return this.defaultSourceSet;
        }
        FileSet fileSet = new FileSet();
        Path srcPath = this.sourceDirectory.toPath();
        Path basePath = this.project.getBasedir().toPath();
        Path relativeSrc = basePath.relativize(srcPath);
        fileSet.addInclude(relativeSrc + "/**");
        fileSet.addInclude("pyproject.toml");
        fileSet.addInclude("poetry.toml");
        fileSet.addInclude("poetry.lock");
        fileSet.addInclude("README.md");
        return fileSet;
    }

    protected ProjectCollectionResult getHabushuProjects() {
        Set directHabushuDeps = this.session.getCurrentProject().getDependencies().stream().filter(d -> "habushu".equals(d.getType())).collect(Collectors.toSet());
        if (directHabushuDeps.size() > 1) {
            throw new HabushuException("More than one `habushu` packaged dependency was found.Only one habushu-type dependency should be specified.");
        }
        if (directHabushuDeps.size() != 1) {
            throw new HabushuException("No `habushu` packaged dependencies were found to containerize.");
        }
        ProjectCollectionResult collectionResult = new ProjectCollectionResult((Dependency)directHabushuDeps.iterator().next());
        return this.collectHabushuDependenciesAsProjects(this.project, collectionResult);
    }

    protected ProjectCollectionResult collectHabushuDependenciesAsProjects(MavenProject currentProject, ProjectCollectionResult collectionResult) {
        Set habushuDeps = currentProject.getDependencies().stream().filter(d -> "habushu".equals(d.getType())).map(ContainerizeDepsMojo::toGav).collect(Collectors.toSet());
        for (MavenProject project : this.getSession().getProjects()) {
            if (!habushuDeps.contains(ContainerizeDepsMojo.toGav(project))) continue;
            logger.info("Found project {} as habushu-type dependency.", (Object)project);
            collectionResult.addProject(project);
            this.collectHabushuDependenciesAsProjects(project, collectionResult);
        }
        return collectionResult;
    }

    protected static String toGav(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
    }

    protected static String toGav(MavenProject project) {
        return project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion();
    }

    protected MavenSession getSession() {
        return this.session;
    }

    protected Path getStagingPath() {
        return this.stagingDirectory.toPath();
    }

    protected void setDockerfile(File dockerfile) {
        this.dockerfile = dockerfile;
    }

    protected void setUpdateDockerfile(boolean update) {
        this.updateDockerfile = update;
    }

    protected void performDockerfileUpdateForVirtualEnvironment(Path targetProjectPath) {
        Path outputDir = this.dockerContext.toPath().relativize(this.getStagingPath());
        String updatedDockerfile = ContainerizeDepsDockerfileHelper.updateDockerfileWithContainerStageLogic(this.dockerfile, outputDir.toString(), targetProjectPath.toString(), this.dockerUser, this.dockerBuilderBase, this.dockerFinalBase);
        try (FileWriter writer = new FileWriter(this.dockerfile);){
            writer.write(updatedDockerfile);
        }
        catch (IOException e) {
            throw new HabushuException("Unable to update Dockerfile.", e);
        }
    }

    protected static class ProjectCollectionResult {
        private final Dependency directDependency;
        private final Set<MavenProject> habushuProjects;
        private MavenProject primaryProject;

        public ProjectCollectionResult(Dependency directDependency) {
            this.directDependency = directDependency;
            this.habushuProjects = new HashSet<MavenProject>();
        }

        public void addProject(MavenProject project) {
            this.habushuProjects.add(project);
            if (ContainerizeDepsMojo.toGav(this.directDependency).equals(ContainerizeDepsMojo.toGav(project))) {
                this.primaryProject = project;
            }
        }

        public Set<MavenProject> getAllProjects() {
            return this.habushuProjects;
        }

        public MavenProject getPrimaryProject() {
            return this.primaryProject;
        }
    }
}

