/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.clean.CleanMojo;
import org.apache.maven.plugins.clean.Fileset;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.exec.PoetryCommandHelper;
import org.technologybrewery.habushu.util.HabushuUtil;

@Mojo(name="clean-habushu", defaultPhase=LifecyclePhase.CLEAN)
public class CleanHabushuMojo
extends CleanMojo {
    @Parameter(defaultValue="${project.basedir}", readonly=true, required=true)
    protected File workingDirectory;
    @Parameter(defaultValue="${project.basedir}/dist", readonly=true, required=true)
    protected File distDirectory;
    @Parameter(defaultValue="${project.basedir}/target", readonly=true, required=true)
    protected File targetDirectory;
    @Parameter(defaultValue="${project.packaging}", readonly=true, required=true)
    protected String packaging;
    @Parameter(property="habushu.deleteVirtualEnv", required=true, defaultValue="false")
    protected boolean deleteVirtualEnv;
    @Parameter(defaultValue="3.11.4", property="habushu.pythonVersion")
    protected String pythonVersion;
    @Parameter(defaultValue="true", property="habushu.usePyenv")
    protected boolean usePyenv;
    @Parameter(defaultValue="${project.build.directory}/pyenv-patch-install-python-version.sh", readonly=true)
    private File patchInstallScript;
    @Parameter(defaultValue="false", property="habushu.rewriteLocalPathDepsInArchives")
    protected boolean rewriteLocalPathDepsInArchives;
    @Parameter(defaultValue="true", property="habushu.useInProjectVirtualEnvironment")
    protected boolean useInProjectVirtualEnvironment;

    public void execute() throws MojoExecutionException {
        if ("habushu".equals(this.packaging)) {
            this.clean();
        } else {
            this.getLog().info((CharSequence)"Skipping execution - packaging type is not 'habushu'");
        }
    }

    private void clean() throws MojoExecutionException {
        ArrayList<Fileset> filesetsToDelete = new ArrayList<Fileset>();
        boolean removeVenvManually = false;
        String virtualEnvFullPath = HabushuUtil.findCurrentVirtualEnvironmentFullPath(this.pythonVersion, this.usePyenv, this.patchInstallScript, this.workingDirectory, this.rewriteLocalPathDepsInArchives, this.getLog());
        virtualEnvFullPath = HabushuUtil.getCleanVirtualEnvironmentPath(virtualEnvFullPath);
        String inVirtualEnvironmentPath = HabushuUtil.getInProjectVirtualEnvironmentPath(this.workingDirectory);
        File venv = new File(inVirtualEnvironmentPath);
        if (this.useInProjectVirtualEnvironment) {
            this.getLog().debug((CharSequence)"`in-project` virtual environment configured for this project");
            if (StringUtils.isNotBlank((CharSequence)virtualEnvFullPath) && !inVirtualEnvironmentPath.equals(virtualEnvFullPath)) {
                this.getLog().warn((CharSequence)"'in-project' virtual environment is configured, but an external virtual environment was found!");
                this.getLog().warn((CharSequence)("Deleting external virtual environment: " + virtualEnvFullPath));
                this.deleteVirtualEnv = true;
            }
        } else if (venv.exists()) {
            this.getLog().warn((CharSequence)"'in-project' virtual environment is NOT configured, but an 'in-project' virtual environment was found!");
            this.getLog().warn((CharSequence)("Deleting 'in-project' virtual environment: " + virtualEnvFullPath));
            this.deleteVirtualEnv = true;
        }
        if (this.deleteVirtualEnv) {
            if (StringUtils.isBlank((CharSequence)virtualEnvFullPath)) {
                this.getLog().warn((CharSequence)"No Poetry virtual environment was detected for deletion.");
            } else {
                String virtualEnvName = new File(virtualEnvFullPath).getName();
                if (StringUtils.isNotBlank((CharSequence)virtualEnvName)) {
                    PoetryCommandHelper poetryHelper = new PoetryCommandHelper(this.workingDirectory);
                    ArrayList<String> arguments = new ArrayList<String>();
                    arguments.add("env");
                    arguments.add("remove");
                    if (!".venv".equals(virtualEnvName)) {
                        arguments.add(virtualEnvName);
                    } else {
                        removeVenvManually = true;
                    }
                    poetryHelper.execute(arguments);
                }
            }
        }
        try {
            Fileset distArchivesFileset = this.createFileset(this.distDirectory);
            filesetsToDelete.add(distArchivesFileset);
            Fileset targetArchivesFileset = this.createFileset(this.targetDirectory);
            filesetsToDelete.add(targetArchivesFileset);
            if (removeVenvManually) {
                filesetsToDelete.add(this.createFileset(venv));
            }
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Could not write to private field in Fileset class.", (Exception)e);
        }
        this.getLog().info((CharSequence)String.format("Deleting distribution archives at %s", this.distDirectory));
        this.getLog().info((CharSequence)String.format("Deleting target archives at %s", this.targetDirectory));
        this.setPrivateParentField("filesets", filesetsToDelete.toArray(new Fileset[0]));
        super.execute();
    }

    private Fileset createFileset(File directory) throws IllegalAccessException {
        Fileset fileset = new Fileset();
        FieldUtils.writeField((Object)fileset, (String)"directory", (Object)directory, (boolean)true);
        return fileset;
    }

    private void setPrivateParentField(String fieldName, Object value) {
        try {
            Field fieldInParentClass = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName);
            fieldInParentClass.setAccessible(true);
            fieldInParentClass.set((Object)this, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new HabushuException("Could not write to field in CleanMojo class.", e);
        }
    }
}

