/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.technologybrewery.habushu.AbstractHabushuMojo;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.util.HabushuUtil;

@Deprecated
@Mojo(name="cache-wheels", defaultPhase=LifecyclePhase.INSTALL)
public class CacheWheelsMojo
extends AbstractHabushuMojo {
    @Parameter(property="habushu.cacheWheels", required=false, defaultValue="false")
    protected boolean cacheWheels;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().warn((CharSequence)"The cache-wheels goal has been deperecated,please see the containerize-dependencies goal instead.");
        if (this.cacheWheels) {
            this.cacheWheels();
        }
    }

    private void cacheWheels() {
        this.getLog().info((CharSequence)"Processing Cache Wheels..");
        try {
            File wheelSourceDirectory = this.getProjectBuildDirectory();
            File poetryWheelCacheDirectory = this.getCachedWheelDirectory(this.project.getArtifactId());
            if (poetryWheelCacheDirectory.exists() || poetryWheelCacheDirectory.mkdirs()) {
                List wheelFiles = Stream.of(wheelSourceDirectory.listFiles()).filter(file -> file.getAbsolutePath().endsWith(".whl")).map(File::getAbsoluteFile).collect(Collectors.toList());
                for (File file2 : wheelFiles) {
                    HabushuUtil.copyFile(file2.getPath(), String.format("%s/%s", poetryWheelCacheDirectory.toPath().toString(), file2.getName()));
                    this.getLog().info((CharSequence)String.format("Cached the %s file", file2.getName()));
                }
            }
        }
        catch (Exception e) {
            throw new HabushuException("Could not cache the " + this.project.getArtifactId() + " wheel file(s)!", e);
        }
    }

    protected File getProjectBuildDirectory() {
        return new File(this.project.getBuild().getDirectory());
    }
}

