/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.technologybrewery.habushu.AbstractHabushuMojo;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.exec.PoetryCommandHelper;

@Mojo(name="build-deployment-artifacts", defaultPhase=LifecyclePhase.PACKAGE)
public class BuildDeploymentArtifactsMojo
extends AbstractHabushuMojo {
    @Parameter(property="habushu.exportRequirementsFile", required=false, defaultValue="true")
    protected boolean exportRequirementsFile;
    @Parameter(property="habushu.cacheWheels", required=false, defaultValue="false")
    protected boolean cacheWheels;
    @Parameter(property="habushu.exportRequirementsWithUrls", required=false, defaultValue="true")
    protected boolean exportRequirementsWithUrls;
    @Parameter(property="habushu.exportRequirementsWithHashes", required=false, defaultValue="true")
    protected boolean exportRequirementsWithHashes;
    @Parameter(property="habushu.exportRequirementsWithoutPathDependencies", required=false, defaultValue="true")
    protected boolean exportRequirementsWithoutPathDependencies;
    @Parameter(property="habushu.exportRequirementsFolder", required=false, defaultValue="${project.basedir}/dist")
    protected String exportRequirementsFolder;
    @Parameter(property="habushu.mavenArtifactFile", required=true, defaultValue="${project.basedir}/target/habushu.placeholder.txt")
    protected File mavenArtifactFile;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        String buildLogMessage;
        String buildCommand;
        PoetryCommandHelper poetryHelper = this.createPoetryCommandHelper();
        if (this.rewriteLocalPathDepsInArchives) {
            buildCommand = "build-rewrite-path-deps";
            buildLogMessage = "Building source and wheel archives with poetry-monorepo-dependency-plugin...";
        } else {
            buildCommand = "build";
            buildLogMessage = "Building source and wheel archives...";
        }
        this.getLog().info((CharSequence)buildLogMessage);
        poetryHelper.executeAndLogOutput(Arrays.asList(buildCommand));
        if (this.exportRequirementsFile) {
            this.getLog().info((CharSequence)"Exporting requirements.txt file...");
            File directory = new File(this.exportRequirementsFolder);
            if (!directory.exists()) {
                directory.mkdir();
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.exportRequirementsWithoutPathDependencies ? "export-without-path-deps" : "export");
            command.add("--output");
            String outputFile = this.exportRequirementsFolder + "/requirements.txt";
            command.add(outputFile);
            if (!this.exportRequirementsWithHashes) {
                command.add("--without-hashes");
            }
            if (!this.exportRequirementsWithUrls) {
                command.add("--without-urls");
            }
            poetryHelper.executeAndLogOutput(command);
            this.setUpPlaceholderFileAsMavenArtifact();
        }
    }

    protected void setUpPlaceholderFileAsMavenArtifact() {
        this.mavenArtifactFile.getParentFile().mkdirs();
        try (PrintWriter writer = new PrintWriter(this.mavenArtifactFile);){
            writer.println("This is NOT the file you are looking for!");
            writer.println();
            writer.println("To take advantage of the Maven Reactor, we want to publish pom files for this artifact.");
            writer.println("But Maven isn't the right solution for managing Python dependencies.");
            writer.println();
            writer.println(String.format("Please check your appropriate Python repository for the %s files instead!", this.project.getArtifactId()));
        }
        catch (FileNotFoundException e) {
            throw new HabushuException("Could not create placeholder artifact file!", e);
        }
        this.project.getArtifact().setFile(this.mavenArtifactFile);
    }
}

