/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.technologybrewery.habushu.AbstractHabushuMojo;
import org.technologybrewery.habushu.exec.PoetryCommandHelper;

@Mojo(name="behave-bdd-test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class BehaveBddTestMojo
extends AbstractHabushuMojo {
    protected static final String BEHAVE_PACKAGE = "behave";
    protected static final String BEHAVE_CUCUMBER_FORMATTER = "kappa-maki";
    @Parameter(property="habushu.behaveOptions", required=false)
    protected String behaveOptions;
    @Parameter(property="habushu.outputCucumberStyleTestReports", required=false, defaultValue="true")
    protected boolean outputCucumberStyleTestReports;
    @Parameter(property="habushu.omitSkippedTests", required=false, defaultValue="true")
    protected boolean omitSkippedTests;
    @Parameter(property="habushu.behaveExcludeManualTag", required=true, defaultValue="true")
    protected boolean behaveExcludeManualTag;
    @Parameter(property="habushu.skipTests", defaultValue="false")
    protected boolean skipTests;
    @Parameter(property="habushu.disableOutputCapture", defaultValue="true")
    protected boolean disableOutputCapture;
    @Parameter(property="habushu.behaveTestEnvironmentVariables")
    protected Map<String, String> behaveTestEnvironmentVariables = null;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        boolean hasTests;
        if (this.skipTests) {
            this.getLog().warn((CharSequence)"Tests are skipped (-DskipTests=true)");
            return;
        }
        File behaveDirectory = new File(this.testDirectory, "features");
        try {
            hasTests = behaveDirectory.exists() && Files.list(behaveDirectory.toPath()).findAny().isPresent();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load behave features directory", (Exception)e);
        }
        if (hasTests) {
            PoetryCommandHelper poetryHelper = this.createPoetryCommandHelper();
            if (!poetryHelper.isDependencyInstalled(BEHAVE_PACKAGE)) {
                this.getLog().info((CharSequence)String.format("%s dependency not specified in pyproject.toml - installing now...", BEHAVE_PACKAGE));
                poetryHelper.installDevelopmentDependency(BEHAVE_PACKAGE);
            }
            ArrayList<String> executeBehaveTestArgs = new ArrayList<String>();
            executeBehaveTestArgs.addAll(Arrays.asList("run", BEHAVE_PACKAGE, this.getCanonicalPathForFile(behaveDirectory)));
            if (this.outputCucumberStyleTestReports) {
                poetryHelper.installDevelopmentDependency(BEHAVE_CUCUMBER_FORMATTER);
                executeBehaveTestArgs.add("--format=kappa_maki.kappa_maki_formatter:PrettyCucumberJSONFormatter");
                executeBehaveTestArgs.add("--outfile=target/cucumber-reports/cucumber.json");
                executeBehaveTestArgs.add("--format=progress2");
            }
            if (this.omitSkippedTests) {
                executeBehaveTestArgs.add("--no-skipped");
            }
            if (this.disableOutputCapture) {
                executeBehaveTestArgs.add("--no-capture");
                executeBehaveTestArgs.add("--no-capture-stderr");
                executeBehaveTestArgs.add("--no-logcapture");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.behaveOptions)) {
                executeBehaveTestArgs.addAll(Arrays.asList(StringUtils.split((String)this.behaveOptions)));
            } else if (this.behaveExcludeManualTag) {
                executeBehaveTestArgs.add("--tags=-manual");
            }
            this.getLog().info((CharSequence)String.format("Executing behave tests in %s...", this.getCanonicalPathForFile(behaveDirectory)));
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            this.getLog().info((CharSequence)"T E S T S");
            this.getLog().info((CharSequence)"-------------------------------------------------------");
            poetryHelper.executeAndLogOutput(executeBehaveTestArgs, this.behaveTestEnvironmentVariables);
        } else {
            this.getLog().warn((CharSequence)String.format("No tests found in %s", this.getCanonicalPathForFile(behaveDirectory)));
        }
    }
}

