/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.technologybrewery.habushu.AbstractHabushuMojo;
import org.technologybrewery.habushu.exec.PoetryCommandHelper;

public abstract class AbstractValidateMojo
extends AbstractHabushuMojo {
    protected static final String LINT_PACKAGE = "pylint";

    protected void runLinter(File lintDirectory, String disabledCheckers, String enabledCheckers, boolean failOnError) throws MojoExecutionException {
        this.runLinter(lintDirectory, disabledCheckers, enabledCheckers, failOnError, null);
    }

    protected void runLinter(File lintDirectory, String disabledCheckers, String enabledCheckers, boolean failOnError, List<String> extraArgs) throws MojoExecutionException {
        PoetryCommandHelper poetryHelper = this.createPoetryCommandHelper();
        if (lintDirectory.exists()) {
            ArrayList<String> executeLintArgs = new ArrayList<String>(Arrays.asList("run", LINT_PACKAGE));
            executeLintArgs.add(this.getCanonicalPathForFile(lintDirectory));
            if (!poetryHelper.isDependencyInstalled(LINT_PACKAGE)) {
                this.getLog().info((CharSequence)String.format("%s dependency not specified in pyproject.toml - installing now...", LINT_PACKAGE));
                poetryHelper.installDevelopmentDependency(LINT_PACKAGE);
            }
            if (StringUtils.isNotEmpty((CharSequence)disabledCheckers)) {
                executeLintArgs.addAll(Arrays.asList("--disable", disabledCheckers));
            }
            if (StringUtils.isNotEmpty((CharSequence)enabledCheckers)) {
                executeLintArgs.addAll(Arrays.asList("--enable", enabledCheckers));
            }
            if (CollectionUtils.isNotEmpty(extraArgs)) {
                executeLintArgs.addAll(extraArgs);
            }
            if (!failOnError) {
                executeLintArgs.add("--exit-zero");
            }
            this.getLog().info((CharSequence)"Validating code using Pylint...");
            poetryHelper.executeAndLogOutput(executeLintArgs);
        } else {
            this.getLog().warn((CharSequence)String.format("Configured linting directory (%s) does not exist - skipping...", lintDirectory));
        }
    }
}

