/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.habushu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.technologybrewery.habushu.HabushuException;
import org.technologybrewery.habushu.exec.PoetryCommandHelper;
import org.technologybrewery.habushu.exec.PyenvCommandHelper;
import org.technologybrewery.habushu.util.MavenPasswordDecoder;

public abstract class AbstractHabushuMojo
extends AbstractMojo {
    protected static final String SNAPSHOT = "-SNAPSHOT";
    protected static final Pattern SEMVER2_PATTERN = Pattern.compile("\\d+\\.\\d+\\.\\d+-(rc|alpha|beta)\\.\\d+$", 2);
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @Parameter(property="habushu.decryptPassword", defaultValue="true")
    protected boolean decryptPassword;
    @Parameter(defaultValue="${project.packaging}", readonly=true, required=true)
    protected String packaging;
    @Parameter(property="habushu.sourceDirectory", required=true, defaultValue="${project.basedir}/src")
    protected File sourceDirectory;
    @Parameter(property="habushu.testDirectory", required=true, defaultValue="${project.basedir}/tests")
    protected File testDirectory;
    protected static final String PUBLIC_PYPI_REPO_ID = "pypi";
    public static final String DEV_PYPI_REPO_ID = "dev-pypi";
    public static final String TEST_PYPI_REPOSITORY_URL = "https://test.pypi.org/";
    @Parameter(property="habushu.pypiRepoId", defaultValue="pypi")
    protected String pypiRepoId;
    @Parameter(property="habushu.pypiRepoUrl")
    protected String pypiRepoUrl;
    @Parameter(property="habushu.useDevRepository", defaultValue="false")
    protected boolean useDevRepository;
    @Parameter(property="habushu.devRepositoryId", defaultValue="dev-pypi")
    protected String devRepositoryId;
    @Parameter(property="habushu.devRepositoryUrl", defaultValue="https://test.pypi.org/")
    protected String devRepositoryUrl;
    @Parameter(defaultValue="true", property="habushu.overridePackageVersion")
    protected boolean overridePackageVersion;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="false", property="habushu.rewriteLocalPathDepsInArchives")
    protected boolean rewriteLocalPathDepsInArchives;

    public String findUsernameForServer() {
        return this.findUsernameForServer(this.pypiRepoId);
    }

    public String findUsernameForServer(String repoId) {
        Server server = this.settings.getServer(repoId);
        return server != null ? server.getUsername() : null;
    }

    public String findPasswordForServer() {
        return this.findPasswordForServer(this.pypiRepoId);
    }

    public String findPasswordForServer(String repoId) {
        String password = "";
        if (this.decryptPassword) {
            password = this.decryptServerPassword(repoId);
        } else {
            this.getLog().warn((CharSequence)"Detected use of plain-text password!  This is a security risk!  Please consider using an encrypted password!");
            password = this.findPlaintextPasswordForServer(repoId);
        }
        return password;
    }

    public String decryptServerPassword(String repoId) {
        String decryptedPassword = null;
        try {
            decryptedPassword = MavenPasswordDecoder.decryptPasswordForServer(this.settings, repoId);
        }
        catch (PlexusCipherException | SecDispatcherException e) {
            throw new HabushuException("Unable to decrypt stored passwords.", e);
        }
        return decryptedPassword;
    }

    protected String findPlaintextPasswordForServer(String repoId) {
        Server server = this.settings.getServer(repoId);
        return server != null ? server.getPassword() : null;
    }

    public File getCachedWheelDirectory(String artifactId) {
        try {
            PoetryCommandHelper poetryHelper = this.createPoetryCommandHelper();
            String poetryCacheDirectoryPath = poetryHelper.getPoetryCacheDirectoryPath();
            return new File(String.format("%s/cache/repositories/wheels/%s", poetryCacheDirectoryPath, artifactId));
        }
        catch (Exception e) {
            throw new HabushuException("Could not get the Poetry Cache Wheel directory!", e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("habushu".equals(this.packaging)) {
            this.doExecute();
        } else {
            this.getLog().info((CharSequence)"Skipping execution - packaging type is not 'habushu'");
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected String getCanonicalPathForFile(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new HabushuException("Could not access file: " + file.getName(), ioe);
        }
    }

    protected PyenvCommandHelper createPyenvCommandHelper() {
        return new PyenvCommandHelper(this.getPoetryProjectBaseDir());
    }

    protected PoetryCommandHelper createPoetryCommandHelper() {
        return new PoetryCommandHelper(this.getPoetryProjectBaseDir());
    }

    protected File getPoetryProjectBaseDir() {
        return this.project.getBasedir();
    }

    protected File getPoetryPyProjectTomlFile() {
        return new File(this.getPoetryProjectBaseDir(), "pyproject.toml");
    }

    protected static String getPythonPackageVersion(String pomVersion, boolean addSnapshotNumber, String snapshotNumberDateFormatPattern) {
        Matcher matcher = SEMVER2_PATTERN.matcher(pomVersion);
        if (matcher.matches()) {
            String qualifier = matcher.group(1);
            pomVersion = pomVersion.replace("-" + qualifier + ".", qualifier);
        }
        Object pythonPackageVersion = pomVersion;
        if (AbstractHabushuMojo.isPomVersionSnapshot(pomVersion)) {
            pythonPackageVersion = AbstractHabushuMojo.replaceSnapshotWithDev(pomVersion);
            if (addSnapshotNumber) {
                LocalDateTime currentTime = LocalDateTime.now();
                String snapshotNumber = StringUtils.isNotEmpty((CharSequence)snapshotNumberDateFormatPattern) ? currentTime.format(DateTimeFormatter.ofPattern(snapshotNumberDateFormatPattern)) : String.valueOf(currentTime.toEpochSecond(ZoneOffset.UTC));
                pythonPackageVersion = (String)pythonPackageVersion + snapshotNumber;
            }
        }
        return pythonPackageVersion;
    }

    protected static String replaceSnapshotWithDev(String pomVersion) {
        return pomVersion.substring(0, pomVersion.indexOf(SNAPSHOT)) + ".dev";
    }

    protected static boolean isPomVersionSnapshot(String pomVersion) {
        return pomVersion.endsWith(SNAPSHOT);
    }

    protected List<String> findCustomToolPoetryGroups() {
        ArrayList<String> toolPoetryGroupSections = new ArrayList<String>();
        File pyProjectTomlFile = this.getPoetryPyProjectTomlFile();
        try (BufferedReader reader = new BufferedReader(new FileReader(pyProjectTomlFile));){
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.strip()).startsWith("[tool.poetry.group")) {
                    toolPoetryGroupSections.add(line.replace("[", "").replace("]", ""));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new HabushuException("Problem reading pyproject.toml to search for custom dependency groups!", e);
        }
        return toolPoetryGroupSections;
    }
}

