/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.commons.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.technologybrewery.commons.json.JsonException;

public interface ValidatedElement {
    @JsonIgnore
    default public URL getJsonSchemaUrl() {
        Enumeration<URL> jsonSchema;
        String schemaFileName = this.getSchemaFileName();
        try {
            jsonSchema = this.getClass().getClassLoader().getResources(schemaFileName);
        }
        catch (IOException e) {
            throw new JsonException("Could not find json schema for '" + schemaFileName + "'!", e);
        }
        return jsonSchema.nextElement();
    }

    @JsonIgnore
    public String getSchemaFileName();
}

