/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.commons.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.commons.json.JsonException;
import org.technologybrewery.commons.json.ValidatedElement;

public final class SchemaValidatedJsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(SchemaValidatedJsonUtils.class);

    private SchemaValidatedJsonUtils() {
    }

    public static <T extends ValidatedElement> T readAndValidateJson(File jsonFile, ObjectMapper objectMapper) {
        FileInputStream jsonFileInputStream = null;
        try {
            jsonFileInputStream = new FileInputStream(jsonFile);
        }
        catch (FileNotFoundException e) {
            throw new JsonException(String.format("Could not find requested file: %s", jsonFile.getName()), e);
        }
        return SchemaValidatedJsonUtils.readAndValidateJson(jsonFileInputStream, objectMapper, jsonFile.getName());
    }

    public static <T extends ValidatedElement> T readAndValidateJson(InputStream jsonFileStream, ObjectMapper objectMapper, String fileIdentifier) {
        TypeReference typeReference = new TypeReference<T>(){};
        return SchemaValidatedJsonUtils.readAndValidateJson(jsonFileStream, objectMapper, typeReference, fileIdentifier);
    }

    public static <T extends ValidatedElement> T readAndValidateJson(InputStream jsonFileStream, ObjectMapper objectMapper, TypeReference<T> typeReference, String fileIdentifier) {
        try {
            ValidatedElement instance = (ValidatedElement)objectMapper.readValue(jsonFileStream, typeReference);
            JsonNode jsonNode = objectMapper.readTree(jsonFileStream);
            boolean valid = SchemaValidatedJsonUtils.isValid(objectMapper, jsonNode, instance, fileIdentifier);
            if (!valid) {
                if (logger.isDebugEnabled()) {
                    logger.debug(objectMapper.writeValueAsString((Object)instance));
                }
                throw new JsonException(fileIdentifier + " contained validation errors!");
            }
            return (T)instance;
        }
        catch (Exception e) {
            throw new JsonException("Problem reading json file: " + fileIdentifier, e);
        }
    }

    private static <T extends ValidatedElement> boolean isValid(ObjectMapper objectMapper, JsonNode jsonInstance, T instance, String fileIdentifier) throws JsonException {
        ProcessingReport report = null;
        try {
            ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultVersion(SchemaVersion.DRAFTV4).freeze();
            JsonValidator validator = JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze().getValidator();
            URL targetSchemaUrl = instance.getJsonSchemaUrl();
            JsonNode targetSchemaAsJsonNode = objectMapper.readTree(targetSchemaUrl);
            report = validator.validate(targetSchemaAsJsonNode, jsonInstance);
            if (!report.isSuccess()) {
                for (ProcessingMessage processingMessage : report) {
                    logger.error("{} contains the following error:\n\t{}", (Object)fileIdentifier, (Object)processingMessage);
                }
            }
        }
        catch (Exception e) {
            throw new JsonException("Problem determining if json was schema-valid!", e);
        }
        return report.isSuccess();
    }
}

