/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling;

import java.util.LinkedHashSet;
import java.util.Set;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ProgramReader;
import org.teavm.model.TextLocation;
import org.teavm.model.instructions.AbstractInstructionReader;
import org.teavm.model.instructions.InstructionReader;
import org.teavm.vm.TeaVM;

public class InstructionLocationReader
extends AbstractInstructionReader {
    private Set<String> resources;

    public InstructionLocationReader(Set<String> resources) {
        this.resources = resources;
    }

    public void location(TextLocation location) {
        if (location != null && location.getFileName() != null) {
            this.resources.add(location.getFileName());
        }
    }

    public static Set<String> extractUsedResources(TeaVM vm) {
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        ClassReaderSource classSource = vm.getDependencyClassSource();
        InstructionLocationReader reader = new InstructionLocationReader(resources);
        for (MethodReference methodRef : vm.getMethods()) {
            ProgramReader program;
            MethodReader method;
            ClassReader cls = classSource.get(methodRef.getClassName());
            if (cls == null || (method = cls.getMethod(methodRef.getDescriptor())) == null || (program = method.getProgram()) == null) continue;
            for (int i = 0; i < program.basicBlockCount(); ++i) {
                program.basicBlockAt(i).readAllInstructions((InstructionReader)reader);
            }
        }
        return resources;
    }
}

