/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Iterator;
import java.util.function.IntBinaryOperator;
import org.teavm.hppc.AbstractIterator;
import org.teavm.hppc.AbstractLongCollection;
import org.teavm.hppc.AbstractShortCollection;
import org.teavm.hppc.LongCollection;
import org.teavm.hppc.LongContainer;
import org.teavm.hppc.LongLookupContainer;
import org.teavm.hppc.LongShortAssociativeContainer;
import org.teavm.hppc.LongShortHashMap;
import org.teavm.hppc.LongShortMap;
import org.teavm.hppc.ShortContainer;
import org.teavm.hppc.comparators.LongComparator;
import org.teavm.hppc.comparators.LongShortComparator;
import org.teavm.hppc.cursors.LongCursor;
import org.teavm.hppc.cursors.LongShortCursor;
import org.teavm.hppc.cursors.ShortCursor;
import org.teavm.hppc.predicates.LongPredicate;
import org.teavm.hppc.predicates.LongShortPredicate;
import org.teavm.hppc.predicates.ShortPredicate;
import org.teavm.hppc.procedures.LongProcedure;
import org.teavm.hppc.procedures.LongShortProcedure;
import org.teavm.hppc.procedures.ShortProcedure;
import org.teavm.hppc.sorting.QuickSort;

public class SortedIterationLongShortHashMap
implements LongShortMap {
    public final LongShortHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationLongShortHashMap(LongShortHashMap delegate, LongComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationLongShortHashMap(LongShortHashMap delegate, LongShortComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        long[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0L) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, LongComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            long[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final LongShortComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final long[] keys;
            final short[] values;
            {
                this.keys = SortedIterationLongShortHashMap.this.delegate.keys;
                this.values = SortedIterationLongShortHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<LongShortCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(LongContainer container) {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongShortPredicate predicate) {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public <T extends LongShortProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        short[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends LongShortPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        short[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public LongCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ShortContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public short get(long key) {
        return this.delegate.get(key);
    }

    @Override
    public short getOrDefault(long key, short defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public short put(long key, short value) {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public int putAll(LongShortAssociativeContainer container) {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends LongShortCursor> iterable) {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public short putOrAdd(long key, short putValue, short incrementValue) {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public short addTo(long key, short additionValue) {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public short remove(long key) {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public int indexOf(long key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public short indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public short indexReplace(int index, short newValue) {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, long key, short value) {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public short indexRemove(int index) {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationLongShortHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<LongShortCursor> {
        private final LongShortCursor cursor = new LongShortCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected LongShortCursor fetch() {
            if (this.index < SortedIterationLongShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongShortHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationLongShortHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationLongShortHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongShortCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final SortedIterationLongShortHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationLongShortHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationLongShortHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationLongShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationLongShortHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final SortedIterationLongShortHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationLongShortHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(short value) {
            for (LongShortCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationLongShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationLongShortHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationLongShortHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongShortHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationLongShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongShortHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongShortHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationLongShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongShortHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongShortHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

