/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.plugin.StringAmplifier;

public class StringAmplifierTransformer
implements ClassHolderTransformer {
    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        for (MethodHolder method : cls.getMethods()) {
            if (method.getProgram() == null) continue;
            this.transformProgram(innerSource, method.getProgram());
        }
    }

    private void transformProgram(ClassReaderSource classSource, Program program) {
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                InvokeInstruction invoke;
                if (!(instruction instanceof InvokeInstruction) || (invoke = (InvokeInstruction)instruction).getReceiver() == null) continue;
                MethodReference method = invoke.getMethod();
                String owningClass = method.getClassName();
                if (!classSource.isSuperType(Resource.class.getName(), owningClass).orElse(false).booleanValue() || !method.getReturnType().isObject(String.class)) continue;
                Variable var = program.createVariable();
                InvokeInstruction amplifyInstruction = new InvokeInstruction();
                amplifyInstruction.setMethod(new MethodReference(StringAmplifier.class, "amplify", new Class[]{String.class, String.class}));
                amplifyInstruction.setType(InvocationType.SPECIAL);
                amplifyInstruction.getArguments().add(var);
                amplifyInstruction.setReceiver(invoke.getReceiver());
                amplifyInstruction.setLocation(invoke.getLocation());
                invoke.setReceiver(var);
                invoke.insertNext((Instruction)amplifyInstruction);
            }
        }
    }
}

