/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.ast.Expr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.javascript.TeaVMJavaScriptHost;
import org.teavm.backend.wasm.TeaVMWasmHost;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.dependency.DependencyListener;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReference;
import org.teavm.platform.plugin.AnnotationDependencySupport;
import org.teavm.platform.plugin.AsyncMethodProcessor;
import org.teavm.platform.plugin.ClassLookupDependencySupport;
import org.teavm.platform.plugin.EnumDependencySupport;
import org.teavm.platform.plugin.MetadataIntrinsic;
import org.teavm.platform.plugin.MetadataProviderTransformer;
import org.teavm.platform.plugin.NewInstanceDependencySupport;
import org.teavm.platform.plugin.PlatformDependencyListener;
import org.teavm.platform.plugin.ResourceAccessorDependencyListener;
import org.teavm.platform.plugin.ResourceAccessorTransformer;
import org.teavm.platform.plugin.ResourceReadIntrinsic;
import org.teavm.platform.plugin.ResourceTransformer;
import org.teavm.platform.plugin.StringAmplifier;
import org.teavm.platform.plugin.StringAmplifierTransformer;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

public class PlatformPlugin
implements TeaVMPlugin {
    public void install(TeaVMHost host) {
        if (host.getExtension(TeaVMJavaScriptHost.class) != null) {
            host.add((ClassHolderTransformer)new MetadataProviderTransformer());
            host.add((ClassHolderTransformer)new ResourceTransformer());
            host.add((ClassHolderTransformer)new ResourceAccessorTransformer(host));
            host.add((DependencyListener)new ResourceAccessorDependencyListener());
        } else {
            host.add((ClassHolderTransformer)new StringAmplifierTransformer());
        }
        TeaVMWasmHost wasmHost = (TeaVMWasmHost)host.getExtension(TeaVMWasmHost.class);
        if (wasmHost != null) {
            wasmHost.add(ctx -> new MetadataIntrinsic(ctx.getClassSource(), ctx.getClassLoader(), ctx.getServices(), ctx.getProperties()));
            wasmHost.add(ctx -> new ResourceReadIntrinsic((ClassReaderSource)ctx.getClassSource(), ctx.getClassLoader()));
            wasmHost.add(ctx -> new WasmIntrinsic(){

                public boolean isApplicable(MethodReference methodReference) {
                    return methodReference.getClassName().equals(StringAmplifier.class.getName());
                }

                public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
                    return manager.generate((Expr)invocation.getArguments().get(0));
                }
            });
        }
        host.add((ClassHolderTransformer)new AsyncMethodProcessor());
        host.add((DependencyListener)new NewInstanceDependencySupport());
        host.add((DependencyListener)new ClassLookupDependencySupport());
        host.add((DependencyListener)new EnumDependencySupport());
        host.add((DependencyListener)new AnnotationDependencySupport());
        host.add((DependencyListener)new PlatformDependencyListener());
    }
}

