/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.io.IOException;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.common.ServiceRepository;
import org.teavm.model.AnnotationReader;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.plugin.DefaultMetadataGeneratorContext;
import org.teavm.platform.plugin.MetadataProviderRef;
import org.teavm.platform.plugin.MetadataUtils;
import org.teavm.platform.plugin.ResourceWriterHelper;

public class MetadataProviderNativeGenerator
implements Generator {
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        ClassReader cls = context.getClassSource().get(methodRef.getClassName());
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        AnnotationReader refAnnot = method.getAnnotations().get(MetadataProviderRef.class.getName());
        methodRef = MethodReference.parse((String)refAnnot.getValue("value").getString());
        MetadataGenerator generator = MetadataUtils.createMetadataGenerator(context.getClassLoader(), method, new CallLocation(methodRef), context.getDiagnostics());
        if (generator == null) {
            return;
        }
        DefaultMetadataGeneratorContext metadataContext = new DefaultMetadataGeneratorContext(context.getClassSource(), context.getClassLoader(), context.getProperties(), (ServiceRepository)context);
        Resource resource = generator.generateMetadata(metadataContext, methodRef);
        writer.append("return ");
        ResourceWriterHelper.write(writer, resource);
        writer.append(';').softNewLine();
    }
}

