/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.binary.DataPrimitives;
import org.teavm.backend.wasm.binary.DataStructure;
import org.teavm.backend.wasm.binary.DataType;
import org.teavm.backend.wasm.binary.DataValue;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.common.ServiceRepository;
import org.teavm.model.CallLocation;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataProvider;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.plugin.DefaultMetadataGeneratorContext;
import org.teavm.platform.plugin.MetadataUtils;
import org.teavm.platform.plugin.ResourceTypeDescriptor;
import org.teavm.platform.plugin.ResourceTypeDescriptorProvider;

public class MetadataIntrinsic
implements WasmIntrinsic {
    private ListableClassReaderSource classSource;
    private ClassLoader classLoader;
    private ServiceRepository services;
    private Properties properties;
    private Map<ResourceTypeDescriptor, DataStructure> resourceTypeCache = new HashMap<ResourceTypeDescriptor, DataStructure>();

    public MetadataIntrinsic(ListableClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services, Properties properties) {
        this.classSource = classSource;
        this.classLoader = classLoader;
        this.services = services;
        this.properties = properties;
    }

    public boolean isApplicable(MethodReference methodReference) {
        MethodReader method = this.classSource.resolve(methodReference);
        if (method == null) {
            return false;
        }
        return method.getAnnotations().get(MetadataProvider.class.getName()) != null;
    }

    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        MethodReader method = this.classSource.resolve(invocation.getMethod());
        MetadataGenerator generator = MetadataUtils.createMetadataGenerator(this.classLoader, method, new CallLocation(invocation.getMethod()), manager.getDiagnostics());
        if (generator == null) {
            return new WasmInt32Constant(0);
        }
        DefaultMetadataGeneratorContext metadataContext = new DefaultMetadataGeneratorContext(this.classSource, this.classLoader, this.properties, this.services);
        Resource resource = generator.generateMetadata(metadataContext, invocation.getMethod());
        int address = this.writeValue(manager.getBinaryWriter(), manager.getStringPool(), resource);
        return new WasmInt32Constant(address);
    }

    private int writeValue(BinaryWriter writer, WasmStringPool stringPool, Object value) {
        if (value instanceof String) {
            return stringPool.getStringPointer((String)value);
        }
        if (value instanceof ResourceTypeDescriptorProvider && value instanceof Resource) {
            return this.writeResource(writer, stringPool, (ResourceTypeDescriptorProvider)value);
        }
        throw new IllegalArgumentException("Don't know how to write resource: " + value);
    }

    private int writeResource(BinaryWriter writer, WasmStringPool stringPool, ResourceTypeDescriptorProvider resourceType) {
        DataStructure structure = this.getDataStructure(resourceType.getDescriptor());
        DataValue value = structure.createValue();
        int address = writer.append(value);
        Object[] propertyValues = resourceType.getValues();
        for (String propertyName : resourceType.getDescriptor().getPropertyTypes().keySet()) {
            Class<?> propertyType = resourceType.getDescriptor().getPropertyTypes().get(propertyName);
            int index = resourceType.getPropertyIndex(propertyName);
            Object propertyValue = propertyValues[index];
            this.writeValueTo(writer, stringPool, propertyType, value, index, propertyValue);
        }
        return address;
    }

    private void writeValueTo(BinaryWriter writer, WasmStringPool stringPool, Class<?> type, DataValue target, int index, Object value) {
        if (type == String.class) {
            target.setAddress(index, value != null ? (long)stringPool.getStringPointer((String)value) : 0L);
        } else if (type == Boolean.TYPE) {
            target.setByte(index, (Boolean)value != false ? (byte)1 : 0);
        } else if (type == Byte.TYPE) {
            target.setByte(index, ((Byte)value).byteValue());
        } else if (type == Short.TYPE) {
            target.setShort(index, ((Short)value).shortValue());
        } else if (type == Character.TYPE) {
            target.setShort(index, (short)((Character)value).charValue());
        } else if (type == Integer.TYPE) {
            target.setInt(index, ((Integer)value).intValue());
        } else if (type == Long.TYPE) {
            target.setLong(index, ((Long)value).longValue());
        } else if (type == Float.TYPE) {
            target.setFloat(index, ((Float)value).floatValue());
        } else if (type == Double.TYPE) {
            target.setDouble(index, ((Double)value).doubleValue());
        } else if (value instanceof ResourceTypeDescriptorProvider && value instanceof Resource) {
            int address = this.writeResource(writer, stringPool, (ResourceTypeDescriptorProvider)value);
            target.setAddress(index, (long)address);
        } else if (value == null) {
            target.setAddress(index, 0L);
        } else {
            throw new IllegalArgumentException("Don't know how to write resource: " + value);
        }
    }

    private DataStructure getDataStructure(ResourceTypeDescriptor descriptor) {
        return this.resourceTypeCache.computeIfAbsent(descriptor, t -> {
            ArrayList<String> propertyNames = new ArrayList<String>(descriptor.getPropertyTypes().keySet());
            DataType[] propertyDataTypes = new DataType[propertyNames.size()];
            for (int i = 0; i < propertyNames.size(); ++i) {
                String propertyName = (String)propertyNames.get(i);
                propertyDataTypes[i] = MetadataIntrinsic.getDataType(descriptor.getPropertyTypes().get(propertyName));
            }
            return new DataStructure(4, propertyDataTypes);
        });
    }

    private static DataType getDataType(Class<?> cls) {
        if (cls == Boolean.TYPE || cls == Byte.TYPE) {
            return DataPrimitives.BYTE;
        }
        if (cls == Short.TYPE || cls == Character.TYPE) {
            return DataPrimitives.SHORT;
        }
        if (cls == Integer.TYPE) {
            return DataPrimitives.INT;
        }
        if (cls == Float.TYPE) {
            return DataPrimitives.FLOAT;
        }
        if (cls == Long.TYPE) {
            return DataPrimitives.LONG;
        }
        if (cls == Double.TYPE) {
            return DataPrimitives.DOUBLE;
        }
        return DataPrimitives.ADDRESS;
    }
}

