/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.platform.plugin.BuildTimeResourceGetter;
import org.teavm.platform.plugin.BuildTimeResourceMethod;
import org.teavm.platform.plugin.BuildTimeResourceProxy;
import org.teavm.platform.plugin.BuildTimeResourceProxyFactory;
import org.teavm.platform.plugin.BuildTimeResourceSetter;
import org.teavm.platform.plugin.BuildTimeResourceWriterMethod;
import org.teavm.platform.plugin.ResourceMethodDescriptor;
import org.teavm.platform.plugin.ResourceTypeDescriptor;
import org.teavm.platform.plugin.ResourceTypeDescriptorProvider;
import org.teavm.platform.plugin.ResourceWriter;

class BuildTimeResourceProxyBuilder {
    private Map<Class<?>, BuildTimeResourceProxyFactory> factories = new HashMap();
    private static Map<Class<?>, Object> defaultValues = new HashMap();

    BuildTimeResourceProxyBuilder() {
    }

    public BuildTimeResourceProxy buildProxy(Class<?> iface) {
        return this.factories.computeIfAbsent(iface, k -> this.createFactory(iface)).create();
    }

    private BuildTimeResourceProxyFactory createFactory(Class<?> iface) {
        return new ProxyFactoryCreation(new ResourceTypeDescriptor(iface)).create();
    }

    static {
        defaultValues.put(Boolean.TYPE, false);
        defaultValues.put(Byte.TYPE, (byte)0);
        defaultValues.put(Short.TYPE, (short)0);
        defaultValues.put(Integer.TYPE, 0);
        defaultValues.put(Float.TYPE, Float.valueOf(0.0f));
        defaultValues.put(Double.TYPE, 0.0);
    }

    private static class ProxyFactoryCreation {
        Map<Method, BuildTimeResourceMethod> methods = new HashMap<Method, BuildTimeResourceMethod>();
        private Map<String, Integer> propertyIndexes = new HashMap<String, Integer>();
        private Object[] initialData;
        private ResourceTypeDescriptor descriptor;

        public ProxyFactoryCreation(ResourceTypeDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        BuildTimeResourceProxyFactory create() {
            Method writeMethod;
            for (Map.Entry<Method, ResourceMethodDescriptor> entry : this.descriptor.getMethods().entrySet()) {
                Method method = entry.getKey();
                ResourceMethodDescriptor methodDescriptor = entry.getValue();
                int index = this.getPropertyIndex(methodDescriptor.getPropertyName());
                switch (methodDescriptor.getType()) {
                    case GETTER: {
                        this.methods.put(method, new BuildTimeResourceGetter(index));
                        break;
                    }
                    case SETTER: {
                        this.methods.put(method, new BuildTimeResourceSetter(index));
                    }
                }
            }
            this.initialData = new Object[this.propertyIndexes.size()];
            for (Map.Entry<Object, Object> entry : this.descriptor.getPropertyTypes().entrySet()) {
                String propertyName = (String)entry.getKey();
                Class propertyType = (Class)entry.getValue();
                this.initialData[this.propertyIndexes.get((Object)propertyName).intValue()] = defaultValues.get(propertyType);
            }
            try {
                writeMethod = ResourceWriter.class.getMethod("write", SourceWriter.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError("Method must exist", noSuchMethodException);
            }
            String[] stringArray = new String[this.descriptor.getPropertyTypes().size()];
            for (Map.Entry<String, Integer> entry : this.propertyIndexes.entrySet()) {
                stringArray[entry.getValue().intValue()] = entry.getKey();
            }
            this.methods.put(writeMethod, new BuildTimeResourceWriterMethod(stringArray));
            block19: for (Method method : ResourceTypeDescriptorProvider.class.getDeclaredMethods()) {
                switch (method.getName()) {
                    case "getDescriptor": {
                        this.methods.put(method, (proxy, args) -> this.descriptor);
                        continue block19;
                    }
                    case "getValues": {
                        this.methods.put(method, (proxy, args) -> (Object[])proxy.data.clone());
                        continue block19;
                    }
                    case "getPropertyIndex": {
                        this.methods.put(method, (proxy, args) -> this.propertyIndexes.getOrDefault(args[0], -1));
                    }
                }
            }
            return new BuildTimeResourceProxyFactory(this.methods, this.initialData);
        }

        private int getPropertyIndex(String propertyName) {
            return this.propertyIndexes.computeIfAbsent(propertyName, k -> this.propertyIndexes.size());
        }
    }
}

