/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform;

import java.lang.annotation.Annotation;
import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.dependency.PluggableDependency;
import org.teavm.interop.Address;
import org.teavm.interop.DelegateTo;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSObject;
import org.teavm.platform.PlatformClass;
import org.teavm.platform.PlatformConsole;
import org.teavm.platform.PlatformHelper;
import org.teavm.platform.PlatformObject;
import org.teavm.platform.PlatformQueue;
import org.teavm.platform.PlatformRunnable;
import org.teavm.platform.PlatformSequence;
import org.teavm.platform.PlatformString;
import org.teavm.platform.metadata.ClassResource;
import org.teavm.platform.metadata.StaticFieldResource;
import org.teavm.platform.plugin.PlatformGenerator;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;

public final class Platform {
    private static boolean newInstancePrepared;

    private Platform() {
    }

    @InjectedBy(value=PlatformGenerator.class)
    public static native PlatformObject getPlatformObject(Object var0);

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native Object clone(Object var0);

    @DelegateTo(value="isInstanceLowLevel")
    public static boolean isInstance(PlatformObject obj, PlatformClass cls) {
        return obj != null && !Platform.isUndefined(obj.getPlatformClass().getMetadata()) && Platform.isAssignable(obj.getPlatformClass(), cls);
    }

    @Unmanaged
    private static boolean isInstanceLowLevel(RuntimeClass self, RuntimeObject object) {
        return Platform.isAssignableLowLevel(RuntimeClass.getClass((RuntimeObject)object), self);
    }

    @JSBody(params={"object"}, script="return typeof object === 'undefined';")
    private static native boolean isUndefined(JSObject var0);

    @DelegateTo(value="isAssignableLowLevel")
    public static boolean isAssignable(PlatformClass from, PlatformClass to) {
        if (from == to) {
            return true;
        }
        PlatformSequence<PlatformClass> supertypes = from.getMetadata().getSupertypes();
        for (int i = 0; i < supertypes.getLength(); ++i) {
            if (!Platform.isAssignable(supertypes.get(i), to)) continue;
            return true;
        }
        return false;
    }

    @Unmanaged
    private static boolean isAssignableLowLevel(RuntimeClass from, RuntimeClass to) {
        return to.isSupertypeOf.apply(from);
    }

    @InjectedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native Class<?> asJavaClass(PlatformObject var0);

    public static PlatformConsole getConsole() {
        return (PlatformConsole)Platform.getGlobal();
    }

    @JSBody(script="return $rt_nextId();")
    public static native int nextObjectId();

    public static <T> T newInstance(PlatformClass cls) {
        if (!newInstancePrepared) {
            Platform.prepareNewInstance();
            newInstancePrepared = true;
        }
        return Platform.newInstanceImpl(cls);
    }

    @GeneratedBy(value=PlatformGenerator.class)
    private static native void prepareNewInstance();

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    private static native <T> T newInstanceImpl(PlatformClass var0);

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native PlatformClass lookupClass(String var0);

    @PluggableDependency(value=PlatformGenerator.class)
    @InjectedBy(value=PlatformGenerator.class)
    public static native void initClass(PlatformClass var0);

    @InjectedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native PlatformClass classFromResource(ClassResource var0);

    @InjectedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native Object objectFromResource(StaticFieldResource var0);

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    @DelegateTo(value="getEnumConstantsLowLevel")
    public static native Enum<?>[] getEnumConstants(PlatformClass var0);

    private static Enum<?>[] getEnumConstantsLowLevel(PlatformClass cls) {
        int size = Platform.getEnumConstantsSize(cls);
        if (size < 0) {
            return null;
        }
        Enum[] constants = new Enum[size];
        Platform.fillEnumConstants(cls, constants);
        return constants;
    }

    @DelegateTo(value="getEnumConstantsSizeImpl")
    private static native int getEnumConstantsSize(PlatformClass var0);

    @Unmanaged
    private static int getEnumConstantsSizeImpl(RuntimeClass cls) {
        Address enumValues = cls.enumValues;
        if (enumValues == null) {
            return -1;
        }
        return enumValues.getAddress().toInt();
    }

    @DelegateTo(value="fillEnumConstantsImpl")
    private static native void fillEnumConstants(PlatformClass var0, Enum<?>[] var1);

    @Unmanaged
    private static void fillEnumConstantsImpl(RuntimeClass cls, Address[] array) {
        Address enumValues = cls.enumValues;
        for (int i = 0; i < array.length; ++i) {
            enumValues = enumValues.add(Address.sizeOf());
            array[i] = enumValues.getAddress().getAddress();
        }
    }

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native Annotation[] getAnnotations(PlatformClass var0);

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native void startThread(PlatformRunnable var0);

    private static void launchThread(PlatformRunnable runnable) {
        runnable.run();
    }

    public static void postpone(PlatformRunnable runnable) {
        Platform.schedule(runnable, 0);
    }

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native int schedule(PlatformRunnable var0, int var1);

    public static void killSchedule(int id) {
        ((PlatformHelper)Platform.getGlobal()).killSchedule(id);
    }

    @JSBody(script="return [];")
    public static native <T> PlatformQueue<T> createQueue();

    public static PlatformString stringFromCharCode(int charCode) {
        return ((PlatformHelper)Platform.getGlobal()).getStringClass().fromCharCode(charCode);
    }

    @DelegateTo(value="isPrimitiveLowLevel")
    public static boolean isPrimitive(PlatformClass cls) {
        return cls.getMetadata().isPrimitive();
    }

    @Unmanaged
    private static boolean isPrimitiveLowLevel(RuntimeClass cls) {
        return (cls.flags & 2) != 0;
    }

    @DelegateTo(value="isEnumLowLevel")
    public static boolean isEnum(PlatformClass cls) {
        return cls.getMetadata().isEnum();
    }

    @Unmanaged
    private static boolean isEnumLowLevel(RuntimeClass cls) {
        return (cls.flags & 4) != 0;
    }

    @DelegateTo(value="getArrayItemLowLevel")
    public static PlatformClass getArrayItem(PlatformClass cls) {
        return cls.getMetadata().getArrayItem();
    }

    @Unmanaged
    private static RuntimeClass getArrayItemLowLevel(RuntimeClass cls) {
        return cls.itemType;
    }

    public static String getName(PlatformClass cls) {
        return cls.getMetadata().getName();
    }

    @JSBody(script="return $rt_global;")
    private static native JSObject getGlobal();
}

