/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.interop.Async;
import org.teavm.interop.AsyncCallback;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.PrimitiveType;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.platform.plugin.AsyncCaller;
import org.teavm.runtime.Fiber;

public class AsyncMethodProcessor
implements ClassHolderTransformer {
    private boolean lowLevel;

    public AsyncMethodProcessor(boolean lowLevel) {
        this.lowLevel = lowLevel;
    }

    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        int suffix = 0;
        for (MethodHolder method : List.copyOf(cls.getMethods())) {
            if (!method.hasModifier(ElementModifier.NATIVE) || method.getAnnotations().get(Async.class.getName()) == null || method.getAnnotations().get(GeneratedBy.class.getName()) != null) continue;
            ValueType[] signature = new ValueType[method.parameterCount() + 2];
            for (int i = 0; i < method.parameterCount(); ++i) {
                signature[i] = method.parameterType(i);
            }
            signature[method.parameterCount()] = ValueType.parse(AsyncCallback.class);
            signature[method.parameterCount() + 1] = ValueType.VOID;
            MethodDescriptor asyncDesc = new MethodDescriptor(method.getName(), signature);
            MethodHolder asyncMethod = cls.getMethod(asyncDesc);
            if (asyncMethod != null && asyncMethod.hasModifier(ElementModifier.STATIC) != method.hasModifier(ElementModifier.STATIC)) {
                context.getDiagnostics().error(new CallLocation(method.getReference()), "Methods {{m0}} and {{m1}} must both be either static or non-static", new Object[]{method.getReference(), asyncMethod.getReference()});
            }
            if (this.lowLevel) {
                this.generateLowLevelCall(method, suffix++, context);
                continue;
            }
            this.generateCallerMethod(cls, method);
        }
    }

    private void generateLowLevelCall(MethodHolder method, int suffix, ClassHolderTransformerContext context) {
        String className = method.getOwnerName() + "$" + method.getName() + "$" + suffix;
        context.submit(this.generateCall((MethodReader)method, className));
        method.getModifiers().remove(ElementModifier.NATIVE);
        Program program = new Program();
        method.setProgram(program);
        BasicBlock startBlock = program.createBasicBlock();
        BasicBlock block = program.createBasicBlock();
        JumpInstruction jumpToBlock = new JumpInstruction();
        jumpToBlock.setTarget(block);
        startBlock.add((Instruction)jumpToBlock);
        InvokeInstruction constructorInvocation = new InvokeInstruction();
        constructorInvocation.setType(InvocationType.SPECIAL);
        ArrayList<Object> signature = new ArrayList<Object>();
        Variable instanceVar = program.createVariable();
        ArrayList<Variable> arguments = new ArrayList<Variable>(constructorInvocation.getArguments());
        if (!method.hasModifier(ElementModifier.STATIC)) {
            arguments.add(instanceVar);
            signature.add(ValueType.object((String)method.getOwnerName()));
        }
        for (int i = 0; i < method.parameterCount(); ++i) {
            arguments.add(program.createVariable());
            signature.add(method.parameterType(i));
        }
        signature.add(ValueType.VOID);
        ConstructInstruction newInstruction = new ConstructInstruction();
        newInstruction.setReceiver(program.createVariable());
        newInstruction.setType(className);
        block.add((Instruction)newInstruction);
        constructorInvocation.setInstance(newInstruction.getReceiver());
        constructorInvocation.setMethod(new MethodReference(className, "<init>", signature.toArray(new ValueType[0])));
        constructorInvocation.setArguments(arguments.toArray(new Variable[0]));
        block.add((Instruction)constructorInvocation);
        InvokeInstruction suspendInvocation = new InvokeInstruction();
        suspendInvocation.setType(InvocationType.SPECIAL);
        suspendInvocation.setMethod(new MethodReference(Fiber.class, "suspend", new Class[]{Fiber.AsyncCall.class, Object.class}));
        suspendInvocation.setArguments(new Variable[]{newInstruction.getReceiver()});
        suspendInvocation.setReceiver(program.createVariable());
        block.add((Instruction)suspendInvocation);
        Variable result = suspendInvocation.getReceiver();
        ExitInstruction exitInstruction = new ExitInstruction();
        ValueType returnType = method.getResultType();
        if (returnType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)returnType).getKind()) {
                case BOOLEAN: {
                    result = this.castPrimitive(block, result, "Boolean", returnType);
                    break;
                }
                case BYTE: {
                    result = this.castPrimitive(block, result, "Byte", returnType);
                    break;
                }
                case SHORT: {
                    result = this.castPrimitive(block, result, "Short", returnType);
                    break;
                }
                case CHARACTER: {
                    result = this.castPrimitive(block, result, "Char", returnType);
                    break;
                }
                case INTEGER: {
                    result = this.castPrimitive(block, result, "Int", returnType);
                    break;
                }
                case FLOAT: {
                    result = this.castPrimitive(block, result, "Float", returnType);
                    break;
                }
                case LONG: {
                    result = this.castPrimitive(block, result, "Long", returnType);
                    break;
                }
                case DOUBLE: {
                    result = this.castPrimitive(block, result, "Double", returnType);
                }
            }
        } else if (returnType == ValueType.VOID) {
            result = null;
        } else {
            CastInstruction cast = new CastInstruction();
            cast.setValue(result);
            cast.setTargetType(returnType);
            cast.setReceiver(program.createVariable());
            block.add((Instruction)cast);
            result = cast.getReceiver();
        }
        exitInstruction.setValueToReturn(result);
        block.add((Instruction)exitInstruction);
    }

    private Variable castPrimitive(BasicBlock block, Variable value, String name, ValueType type) {
        InvokeInstruction invoke = new InvokeInstruction();
        invoke.setType(InvocationType.SPECIAL);
        invoke.setMethod(new MethodReference(Fiber.class.getName(), "get" + name, new ValueType[]{ValueType.object((String)"java.lang.Object"), type}));
        invoke.setArguments(new Variable[]{value});
        invoke.setReceiver(block.getProgram().createVariable());
        block.add((Instruction)invoke);
        return invoke.getReceiver();
    }

    private void generateCallerMethod(ClassHolder cls, MethodHolder method) {
        method.getAnnotations().remove(Async.class.getName());
        ValueType[] mappedSignature = method.getSignature();
        mappedSignature[mappedSignature.length - 1] = ValueType.object((String)"java.lang.Object");
        MethodHolder callerMethod = new MethodHolder(method.getName() + "$_asyncCall_$", mappedSignature);
        AnnotationHolder annot = new AnnotationHolder(AsyncCaller.class.getName());
        annot.getValues().put("value", new AnnotationValue(this.getAsyncReference(method.getReference()).toString()));
        callerMethod.getAnnotations().add(annot);
        callerMethod.getAnnotations().add(new AnnotationHolder(Async.class.getName()));
        callerMethod.getModifiers().add(ElementModifier.NATIVE);
        cls.addMethod(callerMethod);
        method.getModifiers().remove(ElementModifier.NATIVE);
        Program program = new Program();
        BasicBlock block = program.createBasicBlock();
        Variable thisVar = program.createVariable();
        InvokeInstruction call = new InvokeInstruction();
        call.setMethod(callerMethod.getReference());
        call.setType(InvocationType.SPECIAL);
        if (!method.hasModifier(ElementModifier.STATIC)) {
            call.setInstance(thisVar);
        } else {
            callerMethod.getModifiers().add(ElementModifier.STATIC);
        }
        Variable[] args = new Variable[method.parameterCount()];
        for (int i = 0; i < method.parameterCount(); ++i) {
            args[i] = program.createVariable();
        }
        call.setArguments(args);
        block.add((Instruction)call);
        ExitInstruction exit = new ExitInstruction();
        ValueType returnType = method.getResultType();
        if (returnType instanceof ValueType.Primitive) {
            call.setReceiver(program.createVariable());
            exit.setValueToReturn(this.unbox(call.getReceiver(), ((ValueType.Primitive)returnType).getKind(), block, program));
        } else if (!(returnType instanceof ValueType.Void)) {
            call.setReceiver(program.createVariable());
            CastInstruction cast = new CastInstruction();
            cast.setValue(call.getReceiver());
            cast.setTargetType(returnType);
            cast.setReceiver(program.createVariable());
            block.add((Instruction)cast);
            exit.setValueToReturn(cast.getReceiver());
        }
        block.add((Instruction)exit);
        method.setProgram(program);
    }

    private MethodReference getAsyncReference(MethodReference methodRef) {
        ValueType[] signature = new ValueType[methodRef.parameterCount() + 2];
        for (int i = 0; i < methodRef.parameterCount(); ++i) {
            signature[i] = methodRef.getDescriptor().parameterType(i);
        }
        signature[methodRef.parameterCount()] = ValueType.parse(AsyncCallback.class);
        signature[methodRef.parameterCount() + 1] = ValueType.VOID;
        return new MethodReference(methodRef.getClassName(), methodRef.getName(), signature);
    }

    private Variable unbox(Variable value, PrimitiveType type, BasicBlock block, Program program) {
        CastInstruction cast = new CastInstruction();
        cast.setValue(value);
        cast.setReceiver(program.createVariable());
        block.add((Instruction)cast);
        InvokeInstruction call = new InvokeInstruction();
        call.setInstance(cast.getReceiver());
        call.setReceiver(program.createVariable());
        call.setType(InvocationType.VIRTUAL);
        block.add((Instruction)call);
        switch (type) {
            case BOOLEAN: {
                call.setMethod(new MethodReference(Boolean.class, "booleanValue", new Class[]{Boolean.TYPE}));
                break;
            }
            case BYTE: {
                call.setMethod(new MethodReference(Byte.class, "byteValue", new Class[]{Boolean.TYPE}));
                break;
            }
            case SHORT: {
                call.setMethod(new MethodReference(Short.class, "shortValue", new Class[]{Short.TYPE}));
                break;
            }
            case CHARACTER: {
                call.setMethod(new MethodReference(Character.class, "charValue", new Class[]{Character.TYPE}));
                break;
            }
            case INTEGER: {
                call.setMethod(new MethodReference(Integer.class, "intValue", new Class[]{Integer.TYPE}));
                break;
            }
            case LONG: {
                call.setMethod(new MethodReference(Long.class, "longValue", new Class[]{Integer.TYPE}));
                break;
            }
            case FLOAT: {
                call.setMethod(new MethodReference(Float.class, "floatValue", new Class[]{Integer.TYPE}));
                break;
            }
            case DOUBLE: {
                call.setMethod(new MethodReference(Double.class, "doubleValue", new Class[]{Integer.TYPE}));
            }
        }
        cast.setTargetType((ValueType)ValueType.object((String)call.getMethod().getClassName()));
        return call.getReceiver();
    }

    private ClassHolder generateCall(MethodReader method, String className) {
        ClassHolder cls = this.generateClassDecl(method, className);
        if (cls == null) {
            return null;
        }
        cls.addMethod(this.generateConstructor(method, cls.getName()));
        cls.addMethod(this.generateRun(method, cls.getName()));
        return cls;
    }

    private ClassHolder generateClassDecl(MethodReader method, String className) {
        ClassHolder cls = new ClassHolder(className);
        cls.getInterfaces().add(Fiber.class.getName() + "$AsyncCall");
        ArrayList<Object> types = new ArrayList<Object>();
        if (!method.hasModifier(ElementModifier.STATIC)) {
            types.add(ValueType.object((String)method.getOwnerName()));
            FieldHolder field = new FieldHolder("instance");
            field.setType((ValueType)ValueType.object((String)method.getOwnerName()));
            cls.addField(field);
        }
        ValueType[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            types.add(parameterTypes[i]);
            FieldHolder field = new FieldHolder("param" + i);
            field.setType(parameterTypes[i]);
            cls.addField(field);
        }
        types.add(ValueType.VOID);
        MethodHolder constructor = new MethodHolder("<init>", types.toArray(new ValueType[0]));
        cls.addMethod(constructor);
        return cls;
    }

    private MethodHolder generateConstructor(MethodReader method, String className) {
        ArrayList<Object> types = new ArrayList<Object>();
        if (!method.hasModifier(ElementModifier.STATIC)) {
            types.add(ValueType.object((String)method.getOwnerName()));
        }
        Collections.addAll(types, method.getParameterTypes());
        types.add(ValueType.VOID);
        MethodHolder constructor = new MethodHolder("<init>", types.toArray(new ValueType[0]));
        Program program = new Program();
        constructor.setProgram(program);
        BasicBlock block = program.createBasicBlock();
        Variable instance = program.createVariable();
        if (!method.hasModifier(ElementModifier.STATIC)) {
            PutFieldInstruction putField = new PutFieldInstruction();
            putField.setValue(program.createVariable());
            putField.setField(new FieldReference(className, "instance"));
            putField.setFieldType((ValueType)ValueType.object((String)method.getOwnerName()));
            putField.setInstance(instance);
            block.add((Instruction)putField);
        }
        for (int i = 0; i < method.parameterCount(); ++i) {
            PutFieldInstruction putField = new PutFieldInstruction();
            putField.setValue(program.createVariable());
            putField.setField(new FieldReference(className, "param" + i));
            putField.setFieldType(method.parameterType(i));
            putField.setInstance(instance);
            block.add((Instruction)putField);
        }
        block.add((Instruction)new ExitInstruction());
        return constructor;
    }

    private MethodHolder generateRun(MethodReader method, String className) {
        MethodHolder runMethod = new MethodHolder("run", new ValueType[]{ValueType.parse(AsyncCallback.class), ValueType.VOID});
        Program program = new Program();
        runMethod.setProgram(program);
        BasicBlock block = program.createBasicBlock();
        Variable instance = program.createVariable();
        Variable callback = program.createVariable();
        InvokeInstruction call = new InvokeInstruction();
        call.setType(InvocationType.SPECIAL);
        ArrayList<Object> types = new ArrayList<Object>();
        ValueType[] parameterTypes = method.getParameterTypes();
        ArrayList<Variable> arguments = new ArrayList<Variable>(call.getArguments());
        if (!method.hasModifier(ElementModifier.STATIC)) {
            GetFieldInstruction getField = new GetFieldInstruction();
            getField.setReceiver(program.createVariable());
            getField.setInstance(instance);
            getField.setField(new FieldReference(className, "instance"));
            getField.setFieldType((ValueType)ValueType.object((String)method.getOwnerName()));
            block.add((Instruction)getField);
            call.setInstance(getField.getReceiver());
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            GetFieldInstruction getField = new GetFieldInstruction();
            getField.setReceiver(program.createVariable());
            getField.setInstance(instance);
            getField.setField(new FieldReference(className, "param" + i));
            getField.setFieldType(parameterTypes[i]);
            block.add((Instruction)getField);
            arguments.add(getField.getReceiver());
            types.add(parameterTypes[i]);
        }
        types.add(ValueType.parse(AsyncCallback.class));
        arguments.add(callback);
        types.add(ValueType.VOID);
        call.setMethod(new MethodReference(method.getOwnerName(), method.getName(), types.toArray(new ValueType[0])));
        call.setArguments(arguments.toArray(new Variable[0]));
        block.add((Instruction)call);
        block.add((Instruction)new ExitInstruction());
        return runMethod;
    }
}

