/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.util.List;
import org.teavm.junit.TestEntryPointTransformer;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.emit.ForkEmitter;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.instructions.BranchingCondition;

class TestEntryPointTransformerForWholeClass
extends TestEntryPointTransformer {
    private List<MethodReference> testMethods;

    TestEntryPointTransformerForWholeClass(List<MethodReference> testMethods, String testClassName) {
        super(testClassName);
        this.testMethods = testMethods;
    }

    @Override
    protected void generateLaunchProgram(MethodHolder method, ClassHolderTransformerContext context) {
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)context.getHierarchy());
        ValueEmitter testName = pe.var(1, String.class);
        for (MethodReference testMethod : this.testMethods) {
            ValueEmitter isTest = testName.invokeSpecial("equals", Boolean.TYPE, new ValueEmitter[]{pe.constant(testMethod.toString()).cast(Object.class)});
            ForkEmitter fork = isTest.fork(BranchingCondition.NOT_EQUAL);
            pe.enter(pe.getProgram().createBasicBlock());
            fork.setThen(pe.getBlock());
            this.generateSingleMethodLaunchProgram(testMethod, context, pe);
            pe.enter(pe.getProgram().createBasicBlock());
            fork.setElse(pe.getBlock());
        }
        pe.construct(IllegalArgumentException.class, new ValueEmitter[]{pe.constant("Invalid test name")}).raise();
    }
}

