/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.dom.html;

import java.util.function.Consumer;
import org.teavm.jso.JSProperty;
import org.teavm.jso.dom.css.ElementCSSInlineStyle;
import org.teavm.jso.dom.events.EventTarget;
import org.teavm.jso.dom.events.FocusEventTarget;
import org.teavm.jso.dom.events.KeyboardEventTarget;
import org.teavm.jso.dom.events.LoadEventTarget;
import org.teavm.jso.dom.events.MouseEventTarget;
import org.teavm.jso.dom.events.WheelEventTarget;
import org.teavm.jso.dom.html.HTMLCollection;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.TextRectangle;
import org.teavm.jso.dom.types.DOMTokenList;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.dom.xml.Node;
import org.teavm.jso.dom.xml.NodeList;

public abstract class HTMLElement
implements Element,
ElementCSSInlineStyle,
EventTarget,
FocusEventTarget,
MouseEventTarget,
WheelEventTarget,
KeyboardEventTarget,
LoadEventTarget {
    public abstract NodeList<? extends HTMLElement> getElementsByTagName(String var1);

    @JSProperty
    public abstract String getTitle();

    @JSProperty
    public abstract void setTitle(String var1);

    @JSProperty
    public abstract String getLang();

    @JSProperty
    public abstract void setLang(String var1);

    @JSProperty
    public abstract boolean isTranslate();

    @JSProperty
    public abstract void setTranslate(boolean var1);

    @JSProperty
    public abstract String getDir();

    @JSProperty
    public abstract void setDir(String var1);

    @JSProperty
    public abstract boolean isHidden();

    @JSProperty
    public abstract void setHidden(boolean var1);

    public abstract void click();

    @JSProperty
    public abstract int getTabIndex();

    @JSProperty
    public abstract void setTabIndex(int var1);

    public abstract void focus();

    public abstract void blur();

    @JSProperty
    public abstract String getAccessKey();

    @JSProperty
    public abstract void setAccessKey(String var1);

    @JSProperty
    public abstract String getAccessKeyLabel();

    @JSProperty
    public abstract int getClientWidth();

    @JSProperty
    public abstract int getClientHeight();

    @JSProperty
    public abstract int getAbsoluteLeft();

    @JSProperty
    public abstract int getAbsoluteTop();

    @JSProperty
    public abstract int getScrollLeft();

    @JSProperty
    public abstract void setScrollLeft(int var1);

    @JSProperty
    public abstract int getScrollTop();

    @JSProperty
    public abstract void setScrollTop(int var1);

    @JSProperty
    public abstract int getScrollWidth();

    @JSProperty
    public abstract int getScrollHeight();

    @JSProperty
    public abstract int getOffsetWidth();

    @JSProperty
    public abstract int getOffsetHeight();

    @JSProperty
    public abstract int getOffsetTop();

    @JSProperty
    public abstract int getOffsetLeft();

    @Override
    @JSProperty
    public abstract HTMLDocument getOwnerDocument();

    @JSProperty
    public abstract HTMLCollection getChildren();

    @JSProperty
    public abstract String getInnerHTML();

    @JSProperty
    public abstract void setInnerHTML(String var1);

    @JSProperty
    public abstract String getInnerText();

    @JSProperty
    public abstract void setInnerText(String var1);

    public abstract TextRectangle getBoundingClientRect();

    @JSProperty
    public abstract String getClassName();

    @JSProperty
    public abstract void setClassName(String var1);

    @JSProperty
    public abstract DOMTokenList getClassList();

    public final HTMLElement withAttr(String name, String value) {
        this.setAttribute(name, value);
        return this;
    }

    public final HTMLElement withChild(String tagName) {
        HTMLElement result = this.getOwnerDocument().createElement(tagName);
        this.appendChild(result);
        return this;
    }

    public final HTMLElement withChild(Node node) {
        this.appendChild(node);
        return this;
    }

    public final HTMLElement withChild(String tagName, Consumer<HTMLElement> consumer) {
        HTMLElement result = this.getOwnerDocument().createElement(tagName);
        this.appendChild(result);
        consumer.accept(result);
        return this;
    }

    public final HTMLElement clear() {
        Node node = this.getLastChild();
        while (node != null) {
            Node prev = node.getPreviousSibling();
            if (node.getNodeType() != 2) {
                this.removeChild(node);
            }
            node = prev;
        }
        return this;
    }

    public final HTMLElement withText(String content) {
        this.clear().appendChild(this.getOwnerDocument().createTextNode(content));
        return this;
    }

    @Override
    public abstract HTMLElement querySelector(String var1);

    public abstract NodeList<? extends HTMLElement> querySelectorAll(String var1);

    public abstract void requestPointerLock();
}

