/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle.tasks;

import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.teavm.backend.wasm.WasmDebugInfoLevel;
import org.teavm.backend.wasm.WasmDebugInfoLocation;
import org.teavm.gradle.api.SourceFilePolicy;
import org.teavm.gradle.tasks.TaskUtils;
import org.teavm.gradle.tasks.TeaVMTask;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.builder.BuildStrategy;

public abstract class GenerateWasmGCTask
extends TeaVMTask {
    public GenerateWasmGCTask() {
        this.getStrict().convention((Object)true);
        this.getObfuscated().convention((Object)true);
        this.getDebugInfoLevel().convention((Object)org.teavm.gradle.api.WasmDebugInfoLevel.DEOBFUSCATION);
        this.getDebugInfoLocation().convention((Object)org.teavm.gradle.api.WasmDebugInfoLocation.EXTERNAL);
        this.getSourceMap().convention((Object)false);
        this.getSourceFilePolicy().convention((Object)SourceFilePolicy.LINK_LOCAL_FILES);
    }

    @Input
    public abstract Property<Boolean> getStrict();

    @Input
    public abstract Property<Boolean> getObfuscated();

    @Input
    public abstract Property<org.teavm.gradle.api.WasmDebugInfoLevel> getDebugInfoLevel();

    @Input
    public abstract Property<org.teavm.gradle.api.WasmDebugInfoLocation> getDebugInfoLocation();

    @Input
    public abstract Property<Boolean> getSourceMap();

    @InputFiles
    public abstract ConfigurableFileCollection getSourceFiles();

    @Input
    @Optional
    public abstract Property<SourceFilePolicy> getSourceFilePolicy();

    @Override
    protected void setupBuilder(BuildStrategy builder) {
        builder.setStrict(((Boolean)this.getStrict().get()).booleanValue());
        builder.setObfuscated(((Boolean)this.getObfuscated().get()).booleanValue());
        builder.setDebugInformationGenerated(((Boolean)this.getDebugInformation().get()).booleanValue());
        builder.setSourceMapsFileGenerated(((Boolean)this.getSourceMap().get()).booleanValue());
        switch ((org.teavm.gradle.api.WasmDebugInfoLevel)((Object)this.getDebugInfoLevel().get())) {
            case FULL: {
                builder.setWasmDebugInfoLevel(WasmDebugInfoLevel.FULL);
                break;
            }
            case DEOBFUSCATION: {
                builder.setWasmDebugInfoLevel(WasmDebugInfoLevel.DEOBFUSCATION);
            }
        }
        switch ((org.teavm.gradle.api.WasmDebugInfoLocation)((Object)this.getDebugInfoLocation().get())) {
            case EMBEDDED: {
                builder.setWasmDebugInfoLocation(WasmDebugInfoLocation.EMBEDDED);
                break;
            }
            case EXTERNAL: {
                builder.setWasmDebugInfoLocation(WasmDebugInfoLocation.EXTERNAL);
            }
        }
        builder.setTargetType(TeaVMTargetType.WEBASSEMBLY_GC);
        TaskUtils.applySourceFiles(this.getSourceFiles(), builder);
        TaskUtils.applySourceFilePolicy(this.getSourceFilePolicy(), builder);
    }
}

