/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.longimpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import org.teavm.classlib.java.util.TLongSummaryStatistics;
import org.teavm.classlib.java.util.stream.TDoubleStream;
import org.teavm.classlib.java.util.stream.TIntStream;
import org.teavm.classlib.java.util.stream.TLongStream;
import org.teavm.classlib.java.util.stream.TStream;
import org.teavm.classlib.java.util.stream.longimpl.TAllMatchConsumer;
import org.teavm.classlib.java.util.stream.longimpl.TAnyMatchConsumer;
import org.teavm.classlib.java.util.stream.longimpl.TBoxedLongStream;
import org.teavm.classlib.java.util.stream.longimpl.TCloseHandlingLongStream;
import org.teavm.classlib.java.util.stream.longimpl.TCountingLongConsumer;
import org.teavm.classlib.java.util.stream.longimpl.TDistinctLongStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TDropWhileLongStream;
import org.teavm.classlib.java.util.stream.longimpl.TFilteringLongStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TFindFirstLongConsumer;
import org.teavm.classlib.java.util.stream.longimpl.TFlatMappingLongStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TLimitingLongStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TLongAsDoubleStream;
import org.teavm.classlib.java.util.stream.longimpl.TMappingLongStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TMappingToDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TMappingToIntStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TMappingToObjStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TPeekingLongStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TReducingLongConsumer;
import org.teavm.classlib.java.util.stream.longimpl.TSimpleLongStreamIterator;
import org.teavm.classlib.java.util.stream.longimpl.TSimpleLongStreamSpliterator;
import org.teavm.classlib.java.util.stream.longimpl.TSkippingLongStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TSumLongAsDoubleConsumer;
import org.teavm.classlib.java.util.stream.longimpl.TSumLongConsumer;
import org.teavm.classlib.java.util.stream.longimpl.TSummaryLongConsumer;
import org.teavm.classlib.java.util.stream.longimpl.TTakeWhileLongStream;

public abstract class TSimpleLongStreamImpl
implements TLongStream {
    @Override
    public TLongStream filter(LongPredicate predicate) {
        return new TFilteringLongStreamImpl(this, predicate);
    }

    @Override
    public TLongStream map(LongUnaryOperator mapper) {
        return new TMappingLongStreamImpl(this, mapper);
    }

    @Override
    public <U> TStream<U> mapToObj(LongFunction<? extends U> mapper) {
        return new TMappingToObjStreamImpl<U>(this, mapper);
    }

    @Override
    public TIntStream mapToInt(LongToIntFunction mapper) {
        return new TMappingToIntStreamImpl(this, mapper);
    }

    @Override
    public TDoubleStream mapToDouble(LongToDoubleFunction mapper) {
        return new TMappingToDoubleStreamImpl(this, mapper);
    }

    @Override
    public TLongStream flatMap(LongFunction<? extends TLongStream> mapper) {
        return new TFlatMappingLongStreamImpl(this, mapper);
    }

    @Override
    public TLongStream distinct() {
        return new TDistinctLongStreamImpl(this);
    }

    @Override
    public TLongStream sorted() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return TLongStream.of(array);
    }

    @Override
    public TLongStream peek(LongConsumer action) {
        return new TPeekingLongStreamImpl(this, action);
    }

    @Override
    public TLongStream limit(long maxSize) {
        return new TLimitingLongStreamImpl(this, (int)maxSize);
    }

    @Override
    public TLongStream takeWhile(LongPredicate predicate) {
        return new TTakeWhileLongStream(this, predicate);
    }

    @Override
    public TLongStream dropWhile(LongPredicate predicate) {
        return new TDropWhileLongStream(this, predicate);
    }

    @Override
    public TLongStream skip(long n) {
        return new TSkippingLongStreamImpl(this, (int)n);
    }

    @Override
    public void forEach(LongConsumer action) {
        this.forEachOrdered(action);
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        boolean hasMore;
        while (hasMore = this.next(e -> {
            action.accept(e);
            return true;
        })) {
        }
    }

    @Override
    public long[] toArray() {
        int estimatedSize = this.estimateSize();
        if (estimatedSize < 0) {
            ArrayList list = new ArrayList();
            while (this.next(list::add)) {
            }
            long[] array = new long[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Long)list.get(i);
            }
            return array;
        }
        long[] array = new long[estimatedSize];
        ArrayFillingConsumer consumer = new ArrayFillingConsumer(array);
        while (this.next(consumer)) {
        }
        if (consumer.index < array.length) {
            array = Arrays.copyOf(array, consumer.index);
        }
        return array;
    }

    @Override
    public long reduce(long identity, LongBinaryOperator accumulator) {
        TReducingLongConsumer consumer = new TReducingLongConsumer(accumulator, identity, true);
        while (this.next(consumer)) {
        }
        return consumer.result;
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator accumulator) {
        TReducingLongConsumer consumer = new TReducingLongConsumer(accumulator, 0L, false);
        while (this.next(consumer)) {
        }
        return consumer.initialized ? OptionalLong.of(consumer.result) : OptionalLong.empty();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        boolean hasMore;
        Object collection = supplier.get();
        while (hasMore = this.next(e -> {
            accumulator.accept(collection, e);
            return true;
        })) {
        }
        return collection;
    }

    @Override
    public OptionalLong min() {
        return this.reduce(Math::min);
    }

    @Override
    public OptionalLong max() {
        return this.reduce(Math::max);
    }

    @Override
    public long count() {
        TCountingLongConsumer consumer = new TCountingLongConsumer();
        while (this.next(consumer)) {
        }
        return consumer.count;
    }

    @Override
    public long sum() {
        TSumLongConsumer consumer = new TSumLongConsumer();
        while (this.next(consumer)) {
        }
        return consumer.sum;
    }

    @Override
    public OptionalDouble average() {
        TSumLongAsDoubleConsumer consumer = new TSumLongAsDoubleConsumer();
        while (this.next(consumer)) {
        }
        return consumer.count > 0 ? OptionalDouble.of(consumer.sum / (double)consumer.count) : OptionalDouble.empty();
    }

    @Override
    public TLongSummaryStatistics summaryStatistics() {
        TSummaryLongConsumer consumer = new TSummaryLongConsumer();
        while (this.next(consumer)) {
        }
        return consumer.stat;
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        TAnyMatchConsumer consumer = new TAnyMatchConsumer(predicate);
        while (!consumer.matched && this.next(consumer)) {
        }
        return consumer.matched;
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        TAllMatchConsumer consumer = new TAllMatchConsumer(predicate);
        while (consumer.matched && this.next(consumer)) {
        }
        return consumer.matched;
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public OptionalLong findFirst() {
        TFindFirstLongConsumer consumer = new TFindFirstLongConsumer();
        while (!consumer.hasAny && this.next(consumer)) {
        }
        return consumer.hasAny ? OptionalLong.of(consumer.result) : OptionalLong.empty();
    }

    @Override
    public OptionalLong findAny() {
        return this.findFirst();
    }

    @Override
    public TDoubleStream asDoubleStream() {
        return new TLongAsDoubleStream(this);
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        return new TSimpleLongStreamIterator(this);
    }

    @Override
    public Spliterator.OfLong spliterator() {
        return new TSimpleLongStreamSpliterator(this);
    }

    @Override
    public TStream<Long> boxed() {
        return new TBoxedLongStream(this);
    }

    @Override
    public boolean isParallel() {
        return false;
    }

    @Override
    public TLongStream sequential() {
        return this;
    }

    @Override
    public TLongStream parallel() {
        return this;
    }

    @Override
    public TLongStream unordered() {
        return this;
    }

    @Override
    public TLongStream onClose(Runnable closeHandler) {
        return new TCloseHandlingLongStream(this, closeHandler);
    }

    @Override
    public void close() throws Exception {
    }

    protected int estimateSize() {
        return -1;
    }

    public abstract boolean next(LongPredicate var1);

    static class ArrayFillingConsumer
    implements LongPredicate {
        long[] array;
        int index;

        ArrayFillingConsumer(long[] array) {
            this.array = array;
        }

        @Override
        public boolean test(long t) {
            this.array[this.index++] = t;
            return true;
        }
    }
}

