/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.impl;

import java.util.Iterator;
import java.util.function.Predicate;
import org.teavm.classlib.java.util.stream.TStream;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamImpl;

public class TGenericConcatStream<T>
extends TSimpleStreamImpl<T> {
    TStream<? extends T> first;
    TStream<? extends T> second;
    Iterator<? extends T> iterator;
    boolean isSecond;

    public TGenericConcatStream(TStream<? extends T> first, TStream<? extends T> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean next(Predicate<? super T> consumer) {
        if (this.iterator == null) {
            this.iterator = this.first.iterator();
        }
        while (true) {
            if (this.iterator.hasNext()) {
                if (consumer.test(this.iterator.next())) continue;
                return true;
            }
            if (this.isSecond) break;
            this.isSecond = true;
            this.iterator = this.second.iterator();
        }
        return false;
    }

    @Override
    public long count() {
        return this.first.count() + this.second.count();
    }

    @Override
    public void close() throws Exception {
        Exception suppressed = null;
        try {
            this.first.close();
        }
        catch (Exception e) {
            suppressed = e;
        }
        try {
            this.second.close();
        }
        catch (Exception e) {
            if (suppressed != null) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }
}

