/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.security;

import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.security.TNoSuchAlgorithmException;
import org.teavm.classlib.java.util.TRandom;
import org.teavm.jso.crypto.Crypto;
import org.teavm.jso.typedarrays.Uint8Array;

public class TSecureRandom
extends TRandom {
    private static TSecureRandom seedGenerator;

    public TSecureRandom() {
    }

    public TSecureRandom(byte[] seed) {
    }

    public static TSecureRandom getInstance(String algorithm) throws TNoSuchAlgorithmException {
        if (!(algorithm.equals("NativePRNG") || algorithm.equals("NativePRNGBlocking") || algorithm.equals("NativePRNGNonBlocking"))) {
            throw new TNoSuchAlgorithmException();
        }
        return new TSecureRandom();
    }

    public String getAlgorithm() {
        if ((PlatformDetector.isJavaScript() || PlatformDetector.isWebAssemblyGC()) && Crypto.isSupported()) {
            return "NativePRNG";
        }
        return "unknown";
    }

    public void setSeed(byte[] seed) {
    }

    public void reseed() {
    }

    protected int next(int bits) {
        int numBytes = (bits + 7) / 8;
        byte[] bytes = new byte[numBytes];
        this.nextBytes(bytes);
        int val = 0;
        for (int i = 0; i < numBytes; ++i) {
            val = val << 8 | bytes[i] & 0xFF;
        }
        return val >>> numBytes * 8 - bits;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        if ((PlatformDetector.isJavaScript() || PlatformDetector.isWebAssemblyGC()) && Crypto.isSupported()) {
            Uint8Array buffer = new Uint8Array(bytes.length);
            Crypto.current().getRandomValues(buffer);
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)buffer.get(i);
            }
        } else {
            super.nextBytes(bytes);
        }
    }

    @Override
    public int nextInt() {
        if (PlatformDetector.isJavaScript() || PlatformDetector.isWebAssemblyGC()) {
            return this.next(32);
        }
        return super.nextInt();
    }

    @Override
    public double nextDouble() {
        if (PlatformDetector.isJavaScript() || PlatformDetector.isWebAssemblyGC()) {
            return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
        }
        return super.nextDouble();
    }

    public static byte[] getSeed(int numBytes) {
        if (seedGenerator == null) {
            seedGenerator = new TSecureRandom();
        }
        return seedGenerator.generateSeed(numBytes);
    }

    public byte[] generateSeed(int numBytes) {
        if (numBytes < 0) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = new byte[numBytes];
        this.nextBytes(bytes);
        return bytes;
    }
}

