/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TIntBuffer;
import org.teavm.classlib.java.nio.TIntBufferImpl;

class TIntBufferOverArray
extends TIntBufferImpl {
    private boolean readOnly;
    private int start;
    private int capacity;
    private int[] array;

    TIntBufferOverArray(int capacity) {
        this(0, capacity, new int[capacity], 0, capacity, false);
    }

    TIntBufferOverArray(int start, int capacity, int[] array, int position, int limit, boolean readOnly) {
        super(position, limit);
        this.start = start;
        this.capacity = capacity;
        this.readOnly = readOnly;
        this.array = array;
    }

    @Override
    TIntBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TIntBufferOverArray(this.start + start, capacity, this.array, position, limit, readOnly);
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }

    @Override
    int getElement(int index) {
        return this.array[index + this.start];
    }

    @Override
    void putElement(int index, int value) {
        this.array[index + this.start] = value;
    }

    @Override
    boolean isArrayPresent() {
        return true;
    }

    @Override
    int[] getArray() {
        return this.array;
    }

    @Override
    int getArrayOffset() {
        return this.start;
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.nativeOrder();
    }

    @Override
    void getImpl(int index, int[] dst, int offset, int length) {
        System.arraycopy(this.array, this.start + index, dst, offset, length);
    }

    @Override
    void putImpl(int index, int[] src, int offset, int length) {
        System.arraycopy(src, offset, this.array, this.start + index, length);
    }

    @Override
    void putImpl(int index, TIntBuffer src, int offset, int length) {
        if (src.hasArray()) {
            System.arraycopy(src.array(), src.arrayOffset() + offset, this.array, this.start + index, length);
        } else {
            while (length-- > 0) {
                src.putElement(offset++, this.getElement(index++));
            }
        }
    }
}

