/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TFloatBufferImpl;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.DataView;
import org.teavm.jso.typedarrays.Int8Array;

class TFloatBufferOverDataView
extends TFloatBufferImpl
implements TArrayBufferViewProvider {
    private boolean readOnly;
    private DataView data;
    private boolean littleEndian;

    TFloatBufferOverDataView(int position, int limit, boolean readOnly, DataView data, boolean littleEndian) {
        super(position, limit);
        this.readOnly = readOnly;
        this.data = data;
        this.littleEndian = littleEndian;
    }

    @Override
    TFloatBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        DataView slice = new DataView(this.data.getBuffer(), this.data.getByteOffset() + start * 4, capacity * 4);
        return new TFloatBufferOverDataView(position, limit, readOnly, slice, this.littleEndian);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    float getElement(int index) {
        return this.data.getFloat32(index * 4, this.littleEndian);
    }

    @Override
    void putElement(int index, float value) {
        this.data.setFloat32(index * 4, value, this.littleEndian);
    }

    @Override
    void getImpl(int index, float[] dst, int offset, int length) {
        index *= 4;
        while (length-- > 0) {
            dst[offset++] = this.data.getFloat32(index, this.littleEndian);
            index += 4;
        }
    }

    @Override
    void putImpl(int index, TFloatBuffer src, int offset, int length) {
        if (src instanceof TFloatBufferOverDataView) {
            TFloatBufferOverDataView srcImpl = (TFloatBufferOverDataView)src;
            Int8Array srcArray = new Int8Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + offset * 4, length *= 4);
            Int8Array destArray = new Int8Array(this.data.getBuffer(), this.data.getByteOffset() + index * 4, length);
            destArray.set((ArrayBufferView)srcArray, 0);
        } else {
            index *= 4;
            while (length-- > 0) {
                this.data.setFloat32(index, src.get(offset++), this.littleEndian);
                index += 4;
            }
        }
    }

    @Override
    void putImpl(int index, float[] src, int offset, int length) {
        index *= 4;
        while (length-- > 0) {
            this.data.setFloat32(index, src[offset++], this.littleEndian);
            index += 4;
        }
    }

    @Override
    boolean isArrayPresent() {
        return false;
    }

    @Override
    float[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int getArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TByteOrder order() {
        return this.littleEndian ? TByteOrder.LITTLE_ENDIAN : TByteOrder.BIG_ENDIAN;
    }

    @Override
    int capacityImpl() {
        return this.data.getByteLength() / 4;
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 4;
    }
}

