/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TFloatBufferImpl;

class TFloatBufferOverArray
extends TFloatBufferImpl {
    private boolean readOnly;
    private int start;
    private int capacity;
    private float[] array;

    public TFloatBufferOverArray(int capacity) {
        this(0, capacity, new float[capacity], 0, capacity, false);
    }

    public TFloatBufferOverArray(int start, int capacity, float[] array, int position, int limit, boolean readOnly) {
        super(position, limit);
        this.start = start;
        this.capacity = capacity;
        this.readOnly = readOnly;
        this.array = array;
    }

    @Override
    TFloatBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TFloatBufferOverArray(this.start + start, capacity, this.array, position, limit, readOnly);
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }

    @Override
    float getElement(int index) {
        return this.array[index + this.start];
    }

    @Override
    void putElement(int index, float value) {
        this.array[index + this.start] = value;
    }

    @Override
    boolean isArrayPresent() {
        return true;
    }

    @Override
    float[] getArray() {
        return this.array;
    }

    @Override
    int getArrayOffset() {
        return this.start;
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.nativeOrder();
    }

    @Override
    void getImpl(int index, float[] dst, int offset, int length) {
        System.arraycopy(this.array, this.start + index, dst, offset, length);
    }

    @Override
    void putImpl(int index, float[] src, int offset, int length) {
        System.arraycopy(src, offset, this.array, this.start + index, length);
    }

    @Override
    void putImpl(int index, TFloatBuffer src, int offset, int length) {
        if (src.hasArray()) {
            System.arraycopy(src.array(), src.arrayOffset() + offset, this.array, this.start + index, length);
        } else {
            while (length-- > 0) {
                src.putElement(offset++, this.getElement(index++));
            }
        }
    }
}

