/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteBufferImpl;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TCharBufferImpl;

abstract class TCharBufferOverByteBuffer
extends TCharBufferImpl {
    TByteBufferImpl byteBuffer;
    private boolean readOnly;
    int start;
    private int capacity;

    TCharBufferOverByteBuffer(int start, int capacity, TByteBufferImpl byteBuffer, int position, int limit, boolean readOnly) {
        super(position, limit);
        this.start = start;
        this.capacity = capacity;
        this.byteBuffer = byteBuffer;
        this.readOnly = readOnly;
    }

    @Override
    boolean isArrayPresent() {
        return false;
    }

    @Override
    char[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int getArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    void getImpl(int index, char[] dst, int offset, int length) {
        while (length-- > 0) {
            dst[offset++] = this.getChar(index++);
        }
    }

    @Override
    void putImpl(int index, char[] src, int offset, int length) {
        while (length-- > 0) {
            this.putChar(index++, src[offset++]);
        }
    }

    @Override
    void putImpl(int index, String src, int offset, int length) {
        while (length-- > 0) {
            this.putChar(index++, src.charAt(offset++));
        }
    }

    @Override
    void putImpl(int index, TCharBuffer src, int offset, int length) {
        if (src instanceof TCharBufferOverByteBuffer && src.order() == this.order()) {
            TCharBufferOverByteBuffer srcImpl = (TCharBufferOverByteBuffer)src;
            System.arraycopy(srcImpl.byteBuffer.array, srcImpl.start + index * 2, this.byteBuffer.array, this.start + offset * 2, length * 2);
        } else {
            while (length-- > 0) {
                this.putChar(index++, src.getChar(offset++));
            }
        }
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }
}

