/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteBuffer;
import org.teavm.classlib.java.nio.TByteBufferNative;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TCharBufferWasmGC;
import org.teavm.classlib.java.nio.TDoubleBuffer;
import org.teavm.classlib.java.nio.TDoubleBufferWasmGC;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TFloatBufferWasmGC;
import org.teavm.classlib.java.nio.TIntBuffer;
import org.teavm.classlib.java.nio.TIntBufferWasmGC;
import org.teavm.classlib.java.nio.TJSBufferHelper;
import org.teavm.classlib.java.nio.TLongBuffer;
import org.teavm.classlib.java.nio.TLongBufferWasmGC;
import org.teavm.classlib.java.nio.TShortBuffer;
import org.teavm.classlib.java.nio.TShortBufferWasmGC;
import org.teavm.interop.Address;
import org.teavm.jso.JSObject;

class TByteBufferWasmGC
extends TByteBufferNative {
    JSObject regKey;
    JSObject regToken;

    TByteBufferWasmGC(Object gcRef, byte[] array, int arrayOffset, Object base, Address address, int capacity, boolean readOnly) {
        super(gcRef, array, arrayOffset, base, address, capacity, readOnly);
    }

    @Override
    public void release() {
        if (this.regKey != null) {
            TJSBufferHelper.WasmGC.unregister(this.regToken);
            this.regKey = null;
            this.regToken = null;
        }
        super.release();
    }

    @Override
    void copy(byte[] from, int fromOffset, Address to, int count) {
        for (int i = 0; i < count; ++i) {
            to.putByte(from[fromOffset++]);
            to = to.add(1);
        }
    }

    @Override
    void copy(Address from, byte[] to, int toOffset, int count) {
        for (int i = 0; i < count; ++i) {
            to[toOffset++] = from.getByte();
            from = from.add(1);
        }
    }

    @Override
    public TByteBuffer slice() {
        Address newData = this.address.add(this.position);
        TByteBufferWasmGC result = new TByteBufferWasmGC(this.gcRef, this.array, this.arrayOffset + this.position, this.base, newData, this.remaining(), this.readOnly);
        result.position = 0;
        result.limit = result.capacity();
        result.order = TByteOrder.BIG_ENDIAN;
        return result;
    }

    @Override
    public TByteBuffer duplicate() {
        TByteBufferWasmGC result = new TByteBufferWasmGC(this.gcRef, this.array, this.arrayOffset + this.position, this.base, this.address, this.capacity, this.readOnly);
        result.position = this.position;
        result.limit = this.limit;
        result.mark = this.mark;
        result.order = TByteOrder.BIG_ENDIAN;
        return result;
    }

    @Override
    public TByteBuffer asReadOnlyBuffer() {
        TByteBufferWasmGC result = new TByteBufferWasmGC(this.gcRef, this.array, this.arrayOffset + this.position, this.base, this.address, this.capacity, true);
        result.position = this.position;
        result.limit = this.limit;
        result.mark = this.mark;
        result.order = TByteOrder.BIG_ENDIAN;
        return result;
    }

    @Override
    public TCharBuffer asCharBuffer() {
        int sz = this.remaining() / 2;
        return new TCharBufferWasmGC(this.gcRef, null, 0, sz, this.readOnly, this.base, this.address.add(this.position), sz, this.swap);
    }

    @Override
    public TShortBuffer asShortBuffer() {
        int sz = this.remaining() / 2;
        return new TShortBufferWasmGC(this.gcRef, null, 0, sz, this.readOnly, this.base, this.address.add(this.position), sz, this.swap);
    }

    @Override
    public TIntBuffer asIntBuffer() {
        int sz = this.remaining() / 4;
        return new TIntBufferWasmGC(this.gcRef, null, 0, sz, this.readOnly, this.base, this.address.add(this.position), sz, this.swap);
    }

    @Override
    public TLongBuffer asLongBuffer() {
        int sz = this.remaining() / 8;
        return new TLongBufferWasmGC(this.gcRef, null, 0, sz, this.readOnly, this.base, this.address.add(this.position), sz, this.swap);
    }

    @Override
    public TFloatBuffer asFloatBuffer() {
        int sz = this.remaining() / 4;
        return new TFloatBufferWasmGC(this.gcRef, null, 0, sz, this.readOnly, this.base, this.address.add(this.position), sz, this.swap);
    }

    @Override
    public TDoubleBuffer asDoubleBuffer() {
        int sz = this.remaining() / 8;
        return new TDoubleBufferWasmGC(this.gcRef, null, 0, sz, this.readOnly, this.base, this.address.add(this.position), sz, this.swap);
    }
}

